/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.client.MapAllPartitionsClientRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;

public class MapContainsValueRequest
extends MapAllPartitionsClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private Data value;

    public MapContainsValueRequest() {
    }

    public MapContainsValueRequest(String name, Data value) {
        super(name);
        this.value = value;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return this.getOperationProvider().createContainsValueOperationFactory(this.name, this.value);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        for (Object contains : map.values()) {
            if (!Boolean.TRUE.equals(contains)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "containsValue";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

