/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitors;

import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.monitors.PerformanceLogFile;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;

public class PerformanceMonitor {
    final MetricsRegistry metricRegistry;
    final HazelcastInstanceImpl hazelcastInstance;
    final ILogger logger;
    final InternalOperationService operationService;
    final PerformanceLogFile performanceLogFile;
    final boolean humanFriendlyFormat;
    private final Node node;
    private final MonitorThread monitorThread;
    private final boolean enabled;

    public PerformanceMonitor(HazelcastInstanceImpl hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.node = hazelcastInstance.node;
        this.operationService = this.node.nodeEngine.getOperationService();
        this.logger = this.node.getLogger(PerformanceMonitor.class);
        this.metricRegistry = hazelcastInstance.node.nodeEngine.getMetricsRegistry();
        this.enabled = this.node.getGroupProperties().getBoolean(GroupProperty.PERFORMANCE_MONITOR_ENABLED);
        this.humanFriendlyFormat = this.node.getGroupProperties().getBoolean(GroupProperty.PERFORMANCE_MONITOR_HUMAN_FRIENDLY_FORMAT);
        this.performanceLogFile = new PerformanceLogFile(this);
        this.monitorThread = this.initMonitorThread();
    }

    private MonitorThread initMonitorThread() {
        if (!this.enabled) {
            return null;
        }
        HazelcastThreadGroup threadGroup = this.node.getHazelcastThreadGroup();
        int delaySeconds = this.node.getGroupProperties().getSeconds(GroupProperty.PERFORMANCE_MONITOR_DELAY_SECONDS);
        return new MonitorThread(threadGroup, delaySeconds);
    }

    public PerformanceMonitor start() {
        if (!this.enabled) {
            this.logger.finest("PerformanceMonitor disabled");
            return this;
        }
        this.logger.info("PerformanceMonitor started");
        if (!this.node.getGroupProperties().getBoolean(GroupProperty.SLOW_OPERATION_DETECTOR_ENABLED)) {
            this.logger.info(String.format("To enable the SlowOperationDetector in the Performance log, set the following property: -D%s=true", GroupProperty.SLOW_OPERATION_DETECTOR_ENABLED));
        }
        this.monitorThread.start();
        return this;
    }

    private final class MonitorThread
    extends Thread {
        private static final int DELAY_MILLIS = 1000;
        private final int delaySeconds;

        private MonitorThread(HazelcastThreadGroup threadGroup, int delaySeconds) {
            super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix("PerformanceMonitor"));
            this.delaySeconds = delaySeconds;
        }

        @Override
        public void run() {
            try {
                while (PerformanceMonitor.this.node.getState() == NodeState.ACTIVE) {
                    PerformanceMonitor.this.performanceLogFile.render();
                    this.sleep();
                }
                PerformanceMonitor.this.performanceLogFile.render();
            }
            catch (Throwable t) {
                PerformanceMonitor.this.logger.warning(t.getMessage(), t);
            }
        }

        private void sleep() {
            for (int k = 0; k < this.delaySeconds; ++k) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!PerformanceMonitor.this.performanceLogFile.isRenderingForced()) continue;
                PerformanceMonitor.this.logger.info("Detected a request to update the Performance Log");
                return;
            }
        }
    }
}

