/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.unsafe.ContextUtils;

final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    static Span getCurrentSpan() {
        return (Span)ContextUtils.CONTEXT_SPAN_KEY.get(Context.current());
    }

    static Scope withSpan(Span span) {
        return new WithSpan(span, ContextUtils.CONTEXT_SPAN_KEY);
    }

    private static final class WithSpan
    implements Scope {
        private final Context origContext;

        WithSpan(Span span, Context.Key<Span> contextKey) {
            this.origContext = Context.current().withValue(contextKey, (Object)span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
        }
    }
}

