/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public final class TableSubject
extends Subject<TableSubject, Table<?, ?, ?>> {
    TableSubject(FailureMetadata metadata, @Nullable Table<?, ?, ?> table) {
        super(metadata, table);
    }

    public void isEmpty() {
        if (!((Table)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((Table)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        int actualSize = ((Table)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (!((Table)this.actual()).contains(rowKey, columnKey)) {
            this.fail("contains mapping for row/column", rowKey, columnKey);
        }
    }

    public void doesNotContain(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (((Table)this.actual()).contains(rowKey, columnKey)) {
            this.fail("does not contain mapping for row/column", rowKey, columnKey);
        }
    }

    public void containsCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        this.containsCell(Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value));
    }

    public void containsCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        if (!((Table)this.actual()).cellSet().contains(cell)) {
            this.fail("contains cell", (Object)cell);
        }
    }

    public void doesNotContainCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        this.doesNotContainCell(Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value));
    }

    public void doesNotContainCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        if (((Table)this.actual()).cellSet().contains(cell)) {
            this.fail("does not contain cell", (Object)cell);
        }
    }

    public void containsRow(@Nullable Object rowKey) {
        if (!((Table)this.actual()).containsRow(rowKey)) {
            this.fail("contains row", rowKey);
        }
    }

    public void containsColumn(@Nullable Object columnKey) {
        if (!((Table)this.actual()).containsColumn(columnKey)) {
            this.fail("contains column", columnKey);
        }
    }

    public void containsValue(@Nullable Object value) {
        if (!((Table)this.actual()).containsValue(value)) {
            this.fail("contains value", value);
        }
    }
}

