/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Resolve;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="LiteralClassName", category=BugPattern.Category.JDK, summary="Using Class.forName is unnecessary if the class is available at compile-time.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class LiteralClassName
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CLASS_NAME = MethodMatchers.staticMethod().onClass("java.lang.Class").withSignature("forName(java.lang.String)");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CLASS_NAME.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree argument = (Tree)Iterables.getOnlyElement(tree.getArguments());
        if (argument.getKind() != Tree.Kind.STRING_LITERAL) {
            return Description.NO_MATCH;
        }
        String className = (String)ASTHelpers.constValue((Tree)argument, String.class);
        if (className == null) {
            return Description.NO_MATCH;
        }
        if (className.startsWith("[")) {
            return Description.NO_MATCH;
        }
        Type type = state.getTypeFromString(className);
        if (type == null) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol owner = ASTHelpers.getSymbol((ClassTree)((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})));
        Enter enter = Enter.instance(state.context);
        if (!Resolve.instance(state.context).isAccessible(enter.getEnv(owner), type.tsym)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String replaceWith = String.format("%s.class", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)state.getTypes().erasure(type)));
        if (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            fix.addStaticImport("java.util.Objects.requireNonNull");
            replaceWith = String.format("requireNonNull(%s)", replaceWith);
        }
        fix.replace((Tree)tree, replaceWith);
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

