/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Objects;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ForkJoinTask;
import java.util.regex.Pattern;

@BugPattern(name="FutureReturnValueIgnored", summary="Return value of methods returning Future must be checked. Ignoring returned Futures suppresses exceptions thrown from the code that completes the Future.", explanation="Methods that return `java.util.concurrent.Future` and its subclasses generally indicate errors by returning a future that eventually fails.\n\nIf you don\u2019t check the return value of these methods, you will never find out if they threw an exception.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class FutureReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> BLACKLIST = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(ForkJoinTask.class.getName()).named("fork").withParameters(new String[0]), MethodMatchers.instanceMethod().onDescendantOf(CompletionService.class.getName()).named("submit"), MethodMatchers.instanceMethod().onDescendantOf("io.netty.channel.ChannelFuture").withNameMatching(Pattern.compile("addListeners?")), MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.CompletableFuture").withNameMatching(Pattern.compile("completeAsync|orTimeout|completeOnTimeout"))});
    private static final Matcher<ExpressionTree> MATCHER = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type futureType = Objects.requireNonNull(state.getTypeFromString("java.util.concurrent.Future"));
            Symbol untypedSymbol = ASTHelpers.getSymbol((Tree)tree);
            if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
                return false;
            }
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
            if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
                return false;
            }
            for (Symbol.MethodSymbol superSym : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, (VisitorState)state) || !ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)superSym.getReturnType(), (Types)state.getTypes()), (Type)futureType, (VisitorState)state)) continue;
                return false;
            }
            if (BLACKLIST.matches((Tree)tree, state)) {
                return false;
            }
            Type returnType = sym.getReturnType();
            return ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
        }
    };

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }
}

