/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.ElementKind;

public class CompileTimeConstantExpressionMatcher
implements Matcher<ExpressionTree> {
    private static final String COMPILE_TIME_CONSTANT_ANNOTATION = CompileTimeConstant.class.getName();
    private final Matcher<ExpressionTree> matcher = Matchers.anyOf(new ExpressionWithConstValueMatcher(), Matchers.kindIs(Tree.Kind.NULL_LITERAL), new FinalCompileTimeConstantParameterMatcher());

    @Override
    public boolean matches(ExpressionTree t, VisitorState state) {
        return this.matcher.matches(t, state);
    }

    private static boolean hasAttribute(Symbol symbol, String name, VisitorState state) {
        Symbol annotation = state.getSymbolFromString(name);
        return annotation != null && symbol.attribute(annotation) != null;
    }

    public static boolean hasCompileTimeConstantAnnotation(VisitorState state, Symbol symbol) {
        return CompileTimeConstantExpressionMatcher.hasAttribute(symbol, COMPILE_TIME_CONSTANT_ANNOTATION, state);
    }

    private static final class FinalCompileTimeConstantParameterMatcher
    implements Matcher<ExpressionTree> {
        private FinalCompileTimeConstantParameterMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree t, VisitorState state) {
            if (t.getKind() != Tree.Kind.IDENTIFIER) {
                return false;
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)ASTHelpers.getSymbol(t);
            Symbol owner = varSymbol.owner;
            ElementKind ownerKind = owner.getKind();
            if (ownerKind != ElementKind.METHOD && ownerKind != ElementKind.CONSTRUCTOR) {
                return false;
            }
            if ((varSymbol.flags() & 0x10L) != 16L && (varSymbol.flags() & 0x20000000000L) != 0x20000000000L) {
                return false;
            }
            return CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, varSymbol);
        }
    }

    private static final class ExpressionWithConstValueMatcher
    implements Matcher<ExpressionTree> {
        private ExpressionWithConstValueMatcher() {
        }

        @Override
        public boolean matches(ExpressionTree t, VisitorState state) {
            Object constValue = ((JCTree.JCExpression)t).type.constValue();
            return constValue != null;
        }
    }
}

