/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public abstract class RelativePath
implements Comparable<RelativePath> {
    protected final String path;

    protected RelativePath(String p) {
        this.path = p;
    }

    public abstract RelativeDirectory dirname();

    public abstract String basename();

    public Path resolveAgainst(Path directory) throws InvalidPathException {
        String sep = directory.getFileSystem().getSeparator();
        return directory.resolve(this.path.replace("/", sep));
    }

    public Path resolveAgainst(FileSystem fs) throws InvalidPathException {
        String sep = fs.getSeparator();
        Path root = fs.getRootDirectories().iterator().next();
        return root.resolve(this.path.replace("/", sep));
    }

    @Override
    public int compareTo(RelativePath other) {
        return this.path.compareTo(other.path);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RelativePath)) {
            return false;
        }
        return this.path.equals(((RelativePath)other).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "RelPath[" + this.path + "]";
    }

    public String getPath() {
        return this.path;
    }

    public static class RelativeFile
    extends RelativePath {
        static RelativeFile forClass(CharSequence className, JavaFileObject.Kind kind) {
            return new RelativeFile(className.toString().replace('.', '/') + kind.extension);
        }

        public RelativeFile(String p) {
            super(p);
            if (p.endsWith("/")) {
                throw new IllegalArgumentException(p);
            }
        }

        public RelativeFile(RelativeDirectory d, String p) {
            this(d.path + p);
        }

        RelativeFile(RelativeDirectory d, RelativePath p) {
            this(d, p.path);
        }

        @Override
        public RelativeDirectory dirname() {
            int sep = this.path.lastIndexOf(47);
            return new RelativeDirectory(this.path.substring(0, sep + 1));
        }

        @Override
        public String basename() {
            int sep = this.path.lastIndexOf(47);
            return this.path.substring(sep + 1);
        }

        ZipEntry getZipEntry(ZipFile zip) {
            return zip.getEntry(this.path);
        }

        @Override
        public String toString() {
            return "RelativeFile[" + this.path + "]";
        }
    }

    public static class RelativeDirectory
    extends RelativePath {
        static RelativeDirectory forPackage(CharSequence packageName) {
            return new RelativeDirectory(packageName.toString().replace('.', '/'));
        }

        public RelativeDirectory(String p) {
            super((String)(p.length() == 0 || p.endsWith("/") ? p : p + "/"));
        }

        public RelativeDirectory(RelativeDirectory d, String p) {
            this(d.path + p);
        }

        @Override
        public RelativeDirectory dirname() {
            int l = this.path.length();
            if (l == 0) {
                return this;
            }
            int sep = this.path.lastIndexOf(47, l - 2);
            return new RelativeDirectory(this.path.substring(0, sep + 1));
        }

        @Override
        public String basename() {
            int l = this.path.length();
            if (l == 0) {
                return this.path;
            }
            int sep = this.path.lastIndexOf(47, l - 2);
            return this.path.substring(sep + 1, l - 1);
        }

        boolean contains(RelativePath other) {
            return other.path.length() > this.path.length() && other.path.startsWith(this.path);
        }

        @Override
        public String toString() {
            return "RelativeDirectory[" + this.path + "]";
        }
    }
}

