/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.AlignmentRule;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.List;

public class AlignmentRules {
    private static final int DEFAULT_ALIGNMENT = 1;
    private List<AlignmentRule> mRules = Lists.newArrayList();

    public void add(AlignmentRule rule) {
        this.mRules.add(rule);
    }

    public int alignment(String path) {
        int lastSlashIdx;
        if (path.endsWith(Character.toString('/'))) {
            path = path.substring(0, path.length() - 1);
        }
        Verify.verify(((lastSlashIdx = path.lastIndexOf(47)) != 0 ? 1 : 0) != 0);
        if (lastSlashIdx > 0) {
            path = path.substring(lastSlashIdx + 1);
        }
        Verify.verify((path.indexOf(47) == -1 ? 1 : 0) != 0);
        for (AlignmentRule rule : this.mRules) {
            if (!rule.getPattern().matcher(path).matches()) continue;
            int alignment = rule.getAlignment();
            Verify.verify((alignment >= 1 ? 1 : 0) != 0);
            return alignment;
        }
        return 1;
    }
}

