/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractContainerTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.Platform;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public abstract class AbstractMapTester<K, V>
extends AbstractContainerTester<Map<K, V>, Map.Entry<K, V>> {
    protected Map<K, V> getMap() {
        return (Map)this.container;
    }

    @Override
    protected Collection<Map.Entry<K, V>> actualContents() {
        return this.getMap().entrySet();
    }

    protected final void resetMap() {
        this.resetContainer();
    }

    protected void resetMap(Map.Entry<K, V>[] entries) {
        this.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(entries));
    }

    protected void expectMissingKeys(K ... elements) {
        for (K element : elements) {
            AbstractMapTester.assertFalse((String)("Should not contain key " + element), (boolean)this.getMap().containsKey(element));
        }
    }

    protected void expectMissingValues(V ... elements) {
        for (V element : elements) {
            AbstractMapTester.assertFalse((String)("Should not contain value " + element), (boolean)this.getMap().containsValue(element));
        }
    }

    protected Map.Entry<K, V>[] createArrayWithNullKey() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullKeyLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullKeyLocation];
        array[nullKeyLocation] = this.entry(null, oldEntry.getValue());
        return array;
    }

    protected V getValueForNullKey() {
        return this.getEntryNullReplaces().getValue();
    }

    protected K getKeyForNullValue() {
        return this.getEntryNullReplaces().getKey();
    }

    private Map.Entry<K, V> getEntryNullReplaces() {
        Iterator entries = this.getSampleElements().iterator();
        for (int i = 0; i < this.getNullLocation(); ++i) {
            entries.next();
        }
        return (Map.Entry)entries.next();
    }

    protected Map.Entry<K, V>[] createArrayWithNullValue() {
        Map.Entry[] array = (Map.Entry[])this.createSamplesArray();
        int nullValueLocation = this.getNullLocation();
        Map.Entry oldEntry = array[nullValueLocation];
        array[nullValueLocation] = this.entry(oldEntry.getKey(), null);
        return array;
    }

    protected void initMapWithNullKey() {
        this.resetMap(this.createArrayWithNullKey());
    }

    protected void initMapWithNullValue() {
        this.resetMap(this.createArrayWithNullValue());
    }

    protected void expectNullKeyMissingWhenNullKeysUnsupported(String message) {
        try {
            AbstractMapTester.assertFalse((String)message, (boolean)this.getMap().containsKey(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void expectNullValueMissingWhenNullValuesUnsupported(String message) {
        try {
            AbstractMapTester.assertFalse((String)message, (boolean)this.getMap().containsValue(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected MinimalCollection<Map.Entry<K, V>> createDisjointCollection() {
        return MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e4());
    }

    protected int getNumEntries() {
        return this.getNumElements();
    }

    protected Collection<Map.Entry<K, V>> getSampleEntries(int howMany) {
        return this.getSampleElements(howMany);
    }

    protected Collection<Map.Entry<K, V>> getSampleEntries() {
        return this.getSampleElements();
    }

    protected void expectMissing(Map.Entry<K, V> ... entries) {
        for (Map.Entry<K, V> entry : entries) {
            AbstractMapTester.assertFalse((String)("Should not contain entry " + entry), (boolean)this.actualContents().contains(entry));
            AbstractMapTester.assertFalse((String)("Should not contain key " + entry.getKey() + " mapped to value " + entry.getValue()), (boolean)AbstractMapTester.equal(this.getMap().get(entry.getKey()), entry.getValue()));
        }
    }

    private static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected Map.Entry<K, V> entry(K key, V value) {
        return Helpers.mapEntry(key, value);
    }

    @Override
    protected void expectContents(Collection<Map.Entry<K, V>> expected) {
        super.expectContents(expected);
        for (Map.Entry<K, V> entry : expected) {
            AbstractMapTester.assertEquals((String)("Wrong value for key " + entry.getKey()), entry.getValue(), this.getMap().get(entry.getKey()));
        }
    }

    protected final void expectReplacement(Map.Entry<K, V> newEntry) {
        List<Map.Entry<K, V>> expected = Helpers.copyToList(this.getSampleElements());
        this.replaceValue(expected, newEntry);
        this.expectContents((Collection<Map.Entry<K, V>>)expected);
    }

    private void replaceValue(List<Map.Entry<K, V>> expected, Map.Entry<K, V> newEntry) {
        ListIterator<Map.Entry<K, V>> i = expected.listIterator();
        while (i.hasNext()) {
            if (!Helpers.equal(i.next().getKey(), newEntry.getKey())) continue;
            i.set(newEntry);
            return;
        }
        throw new IllegalArgumentException(Platform.format("key %s not found in entries %s", newEntry.getKey(), expected));
    }

    protected V get(K key) {
        return this.getMap().get(key);
    }

    protected final K k0() {
        return ((Map.Entry)this.e0()).getKey();
    }

    protected final V v0() {
        return ((Map.Entry)this.e0()).getValue();
    }

    protected final K k1() {
        return ((Map.Entry)this.e1()).getKey();
    }

    protected final V v1() {
        return ((Map.Entry)this.e1()).getValue();
    }

    protected final K k2() {
        return ((Map.Entry)this.e2()).getKey();
    }

    protected final V v2() {
        return ((Map.Entry)this.e2()).getValue();
    }

    protected final K k3() {
        return ((Map.Entry)this.e3()).getKey();
    }

    protected final V v3() {
        return ((Map.Entry)this.e3()).getValue();
    }

    protected final K k4() {
        return ((Map.Entry)this.e4()).getKey();
    }

    protected final V v4() {
        return ((Map.Entry)this.e4()).getValue();
    }
}

