/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.common;

public class Duration {
    private static final long MAX_SECONDS = 315576000000L;
    private static final int MAX_NANOS = 999999999;
    private static final long NUM_MILLIS_PER_SECOND = 1000L;
    private static final int NUM_NANOS_PER_MILLI = 1000000;
    private final long seconds;
    private final int nanos;

    public static Duration create(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return new Duration(0L, 0);
        }
        if (nanos < -999999999 || nanos > 999999999) {
            return new Duration(0L, 0);
        }
        if (seconds < 0L && nanos > 0 || seconds > 0L && nanos < 0) {
            return new Duration(0L, 0);
        }
        return new Duration(seconds, nanos);
    }

    public static Duration fromMillis(long millis) {
        long seconds = millis / 1000L;
        int nanos = (int)(millis % 1000L) * 1000000;
        return new Duration(seconds, nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration that = (Duration)obj;
        return this.seconds == that.seconds && this.nanos == that.nanos;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + this.nanos;
        return result;
    }

    public String toString() {
        return "Duration<" + this.seconds + "," + this.nanos + ">";
    }

    private Duration(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }
}

