/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2.meta;

import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.meta.Library;
import com.google.common.primitives.Ints;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public final class DetailsTypes {
    private DetailsTypes() {
    }

    public static AndroidVersion getAndroidVersion(ApiDetailsType details) {
        return new AndroidVersion(details.getApiLevel(), details.getCodename());
    }

    public static String getPlatformPath(AndroidVersion version) {
        return "platforms;android-" + version.getApiString();
    }

    public static String getSourcesPath(AndroidVersion version) {
        return "sources;android-" + version.getApiString();
    }

    public static String getLldbPath(Revision revision) {
        return "lldb;" + revision.getMajor() + "." + revision.getMinor();
    }

    public static String getAddonPath(IdDisplay vendor, AndroidVersion version, IdDisplay name) {
        return "add-ons" + ';' + "addon-" + name.getId() + "-" + vendor.getId() + "-" + version.getApiString();
    }

    public static String getSysImgPath(IdDisplay vendor, AndroidVersion version, IdDisplay name, String abi) {
        return "system-images" + ';' + "android-" + version.getApiString() + ';' + name.getId() + ';' + abi;
    }

    public static String getBuildToolsPath(Revision revision) {
        String revisionStr = Ints.join((String)".", (int[])revision.toIntArray(false)) + (revision.isPreview() ? "-preview" : "");
        return "build-tools;" + revisionStr;
    }

    @XmlTransient
    public static interface MavenType {
    }

    @XmlTransient
    public static interface SysImgDetailsType
    extends ApiDetailsType {
        public void setAbi(String var1);

        public String getAbi();

        public boolean isValidAbi(String var1);

        public void setTag(IdDisplay var1);

        public IdDisplay getTag();

        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();
    }

    @XmlTransient
    public static interface AddonDetailsType
    extends ApiDetailsType {
        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();

        public Libraries getLibraries();

        public void setLibraries(Libraries var1);

        public void setTag(IdDisplay var1);

        public IdDisplay getTag();

        public String getDefaultSkin();

        public static abstract class Libraries {
            public abstract List<Library> getLibrary();
        }
    }

    @XmlTransient
    public static interface ExtraDetailsType {
        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();
    }

    @XmlTransient
    public static interface PlatformDetailsType
    extends ApiDetailsType {
        public void setLayoutlib(LayoutlibType var1);

        public LayoutlibType getLayoutlib();

        @XmlTransient
        public static abstract class LayoutlibType {
            public abstract void setApi(int var1);

            public abstract int getApi();
        }
    }

    @XmlTransient
    public static interface SourceDetailsType
    extends ApiDetailsType {
    }

    public static interface ApiDetailsType {
        public void setApiLevel(int var1);

        public int getApiLevel();

        public void setCodename(String var1);

        public String getCodename();
    }
}

