/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableSortedSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Comparator;

class ImmutableSortedSetCodec<E>
implements ObjectCodec<ImmutableSortedSet<E>> {
    ImmutableSortedSetCodec() {
    }

    @Override
    public Class<ImmutableSortedSet<E>> getEncodedClass() {
        return ImmutableSortedSet.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableSortedSet<E> object, CodedOutputStream codedOut) throws SerializationException, IOException {
        context.serialize(object.comparator(), codedOut);
        codedOut.writeInt32NoTag(object.size());
        for (Object obj : object) {
            context.serialize(obj, codedOut);
        }
    }

    @Override
    public ImmutableSortedSet<E> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)((Comparator)context.deserialize(codedIn)));
        int size = codedIn.readInt32();
        for (int i = 0; i < size; ++i) {
            builder.add(context.deserialize(codedIn));
        }
        return builder.build();
    }
}

