/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class DexWrapper {
    private static final LoadingCache<File, LinkedBlockingDeque<DexWrapper>> CACHE = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<File, LinkedBlockingDeque<DexWrapper>>(){

        public LinkedBlockingDeque<DexWrapper> load(File jarFile) throws Exception {
            int poolSize = Integer.getInteger("android.dexerPoolSize", 4);
            LinkedBlockingDeque<DexWrapper> deque = new LinkedBlockingDeque<DexWrapper>(poolSize);
            for (int i = 0; i < poolSize; ++i) {
                deque.push(new DexWrapper(jarFile));
            }
            return deque;
        }
    });
    private static final String DEX_MAIN = "com.android.dx.command.dexer.Main";
    private static final String DEX_CONSOLE = "com.android.dx.command.DxConsole";
    private static final String DEX_ARGS = "com.android.dx.command.dexer.Main$Arguments";
    private static final String MAIN_RUN = "run";
    private Constructor<?> mArgConstructor;
    private Field mAddToDexFutures;
    private Field mArgFileNames;
    private Field mArgJarOutput;
    private Field mArgOutName;
    private Field mArgVerbose;
    private Field mClassesInMainDex;
    private Field mConsoleErr;
    private Field mConsoleOut;
    private Field mDexOutputArrays;
    private Field mDexOutputFutures;
    private Field mForceJumbo;
    private Field mHumanOutWriter;
    private Field mMainDexListFile;
    private Field mMaxFieldIdsInProcess;
    private Field mMaxMethodIdsInProcess;
    private Field mMinimumFileAge;
    private Field mMultiDex;
    private Field mNumThreads;
    private Field mOptimize;
    private File mDexJar;
    private Method mClearList;
    private Method mRunMethod;
    private Method mSetOut;
    private Class<?> mMainClass;

    public static boolean noMainDexOnClasspath() {
        try {
            DexWrapper.class.getClassLoader().loadClass(DEX_MAIN);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }

    public static DexWrapper obtain(File jarFile) {
        try {
            return (DexWrapper)((LinkedBlockingDeque)CACHE.get((Object)jarFile)).takeFirst();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void release() {
        try {
            ((LinkedBlockingDeque)CACHE.get((Object)this.mDexJar)).putFirst(this);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DexWrapper(File jarFile) {
        this.mDexJar = jarFile;
    }

    private void loadDex(File dxJarFile, ILogger logger) {
        logger.info("Loading jar into dexer: %s", new Object[]{this.mDexJar.getAbsolutePath()});
        try {
            if (!dxJarFile.isFile()) {
                throw new RuntimeException("dx.jar not found at : " + dxJarFile);
            }
            URL url = dxJarFile.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, DexWrapper.class.getClassLoader());
            this.mMainClass = loader.loadClass(DEX_MAIN);
            Class<?> consoleClass = loader.loadClass(DEX_CONSOLE);
            Class<?> argClass = loader.loadClass(DEX_ARGS);
            Class<?> systemClass = loader.loadClass("java.lang.System");
            Class<?> listClass = loader.loadClass("java.util.List");
            this.mArgConstructor = argClass.getConstructor(new Class[0]);
            this.mRunMethod = this.mMainClass.getMethod(MAIN_RUN, argClass);
            this.mSetOut = systemClass.getMethod("setOut", loader.loadClass("java.io.PrintStream"));
            this.mClearList = listClass.getMethod("clear", new Class[0]);
            this.mArgOutName = argClass.getField("outName");
            this.mArgJarOutput = argClass.getField("jarOutput");
            this.mArgFileNames = argClass.getField("fileNames");
            this.mArgVerbose = argClass.getField("verbose");
            this.mOptimize = argClass.getField("optimize");
            this.mMultiDex = argClass.getField("multiDex");
            this.mForceJumbo = argClass.getField("forceJumbo");
            this.mMainDexListFile = argClass.getField("mainDexListFile");
            this.mNumThreads = argClass.getField("numThreads");
            this.mConsoleOut = consoleClass.getField("out");
            this.mConsoleErr = consoleClass.getField("err");
            this.mAddToDexFutures = this.getPrivateStaticField("addToDexFutures");
            this.mClassesInMainDex = this.getPrivateStaticField("classesInMainDex");
            this.mDexOutputArrays = this.getPrivateStaticField("dexOutputArrays");
            this.mDexOutputFutures = this.getPrivateStaticField("dexOutputFutures");
            this.mHumanOutWriter = this.getPrivateStaticField("humanOutWriter");
            this.mMaxFieldIdsInProcess = this.getPrivateStaticField("maxFieldIdsInProcess");
            this.mMaxMethodIdsInProcess = this.getPrivateStaticField("maxMethodIdsInProcess");
            this.mMinimumFileAge = this.getPrivateStaticField("minimumFileAge");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Field getPrivateStaticField(String addToDexFutures) throws NoSuchFieldException {
        Field declaredField = this.mMainClass.getDeclaredField(addToDexFutures);
        declaredField.setAccessible(true);
        return declaredField;
    }

    public synchronized ProcessResult run(DexProcessBuilder processBuilder, DexOptions dexOptions, ProcessOutputHandler outputHandler, ILogger logger) throws IOException, ProcessException {
        if (this.mRunMethod == null) {
            this.loadDex(this.mDexJar, logger);
        }
        assert (this.mArgOutName != null);
        assert (this.mArgJarOutput != null);
        assert (this.mArgFileNames != null);
        assert (this.mArgVerbose != null);
        assert (this.mConsoleOut != null);
        assert (this.mConsoleErr != null);
        ProcessOutput processOutput = outputHandler.createOutput();
        Closer closer = Closer.create();
        try {
            PrintStream err = (PrintStream)closer.register((Closeable)new PrintStream(processOutput.getErrorOutput()));
            PrintStream out = (PrintStream)closer.register((Closeable)new PrintStream(processOutput.getStandardOutput()));
            this.mConsoleErr.set(null, err);
            this.mConsoleOut.set(null, out);
            this.mSetOut.invoke(null, out);
            Object args = this.mArgConstructor.newInstance(new Object[0]);
            this.setOutput(args, processBuilder);
            this.setInputs(args, processBuilder);
            this.setOtherOptions(args, processBuilder, dexOptions);
            this.clearState();
            Stopwatch stopwatch = Stopwatch.createStarted();
            Object res = this.mRunMethod.invoke(null, args);
            stopwatch.stop();
            logger.info("Dexing %s in-process: %s", new Object[]{processBuilder.getOutputFile().getPath(), stopwatch});
            if (res instanceof Integer) {
                DexProcessResult dexProcessResult = new DexProcessResult((Integer)res);
                return dexProcessResult;
            }
            try {
                throw new ProcessException("Dex returned value of unknown type: " + res);
            }
            catch (InvocationTargetException e) {
                String exceptionMessage = e.getTargetException().getMessage();
                logger.error(null, "Exception while dexing files: " + exceptionMessage, new Object[0]);
                throw Throwables.propagate((Throwable)e.getTargetException());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        finally {
            closer.close();
            outputHandler.handleOutput(processOutput);
        }
    }

    private void clearState() throws IllegalAccessException, InvocationTargetException {
        this.mClearList.invoke(this.mAddToDexFutures.get(null), new Object[0]);
        this.mClearList.invoke(this.mDexOutputFutures.get(null), new Object[0]);
        this.mMaxMethodIdsInProcess.set(null, 0);
        this.mMaxFieldIdsInProcess.set(null, 0);
        this.mMinimumFileAge.set(null, 0);
        this.mClassesInMainDex.set(null, null);
        this.mClearList.invoke(this.mDexOutputArrays.get(null), new Object[0]);
        this.mHumanOutWriter.set(null, null);
    }

    private void setInputs(Object args, DexProcessBuilder processBuilder) throws IllegalAccessException, ProcessException {
        this.mArgFileNames.set(args, Iterables.toArray(processBuilder.getFilesToAdd(null), String.class));
    }

    private void setOutput(Object args, DexProcessBuilder processBuilder) throws IllegalAccessException {
        if (processBuilder.getOutputFile().isDirectory() && !processBuilder.isMultiDex()) {
            this.mArgOutName.set(args, new File(processBuilder.getOutputFile(), "classes.dex").getPath());
            this.mArgJarOutput.set(args, false);
        } else {
            String outputFileAbsolutePath = processBuilder.getOutputFile().getAbsolutePath();
            this.mArgOutName.set(args, outputFileAbsolutePath);
            this.mArgJarOutput.set(args, outputFileAbsolutePath.endsWith(".jar"));
        }
    }

    private void setOtherOptions(Object args, DexProcessBuilder processBuilder, DexOptions dexOptions) throws IllegalAccessException {
        this.mArgVerbose.set(args, processBuilder.isVerbose());
        this.mOptimize.set(args, !processBuilder.isNoOptimize());
        this.mMultiDex.set(args, processBuilder.isMultiDex());
        if (processBuilder.getMainDexList() != null) {
            this.mMainDexListFile.set(args, processBuilder.getMainDexList().getPath());
        }
        this.mNumThreads.set(args, Objects.firstNonNull((Object)dexOptions.getThreadCount(), (Object)4));
        this.mForceJumbo.set(args, dexOptions.getJumboMode());
        Preconditions.checkArgument((!processBuilder.isIncremental() ? 1 : 0) != 0, (Object)"--incremental is not supported.");
    }

    private static class DexProcessResult
    implements ProcessResult {
        private int mExitValue;

        public DexProcessResult(int exitValue) {
            this.mExitValue = exitValue;
        }

        public ProcessResult assertNormalExitValue() throws ProcessException {
            if (this.mExitValue != 0) {
                throw new ProcessException(String.format("Return code %d for dex process", this.mExitValue));
            }
            return this;
        }

        public int getExitValue() {
            return this.mExitValue;
        }

        public ProcessResult rethrowFailure() throws ProcessException {
            return this.assertNormalExitValue();
        }
    }
}

