/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StringLiteral;

public class SetTextDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(SetTextDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue SET_TEXT_I18N = Issue.create((String)"SetTextI18n", (String)"TextView Internationalization", (String)"When calling `TextView#setText`\n* Never call `Number#toString()` to format numbers; it will not handle fraction separators and locale-specific digits properly. Consider using `String#format` with proper format specifications (`%d` or `%f`) instead.\n* Do not pass a string literal (e.g. \"Hello\") to display text. Hardcoded text can not be properly translated to other languages. Consider using Android resource strings instead.\n* Do not build messages by concatenating text chunks. Such messages can not be properly translated.", (Category)Category.I18N, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/resources/localization.html");
    private static final String METHOD_NAME = "setText";
    private static final String TO_STRING_NAME = "toString";
    private static final String CHAR_SEQUENCE_CLS = "java.lang.CharSequence";
    private static final String NUMBER_CLS = "java.lang.Number";
    private static final String TEXT_VIEW_CLS = "android.widget.TextView";
    private static final String WORD_PATTERN = ".*\\w{2,}.*";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(METHOD_NAME);
    }

    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation call) {
        JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)context.resolve((Node)call);
        if (method != null && method.getContainingClass().matches(TEXT_VIEW_CLS) && method.matches(METHOD_NAME) && method.getArgumentCount() > 0 && method.getArgumentType(0).matchesSignature(CHAR_SEQUENCE_CLS)) {
            SetTextDetector.checkNode(context, call.astArguments().first());
        }
    }

    private static void checkNode(JavaContext context, Node node) {
        if (node instanceof StringLiteral) {
            if (((StringLiteral)node).astValue().matches(WORD_PATTERN)) {
                context.report(SET_TEXT_I18N, node, context.getLocation(node), "String literal in `setText` can not be translated. Use Android resources instead.");
            }
        } else if (node instanceof MethodInvocation) {
            JavaParser.ResolvedClass superClass;
            JavaParser.ResolvedMethod rm = (JavaParser.ResolvedMethod)context.resolve(node);
            if (rm != null && rm.getName().matches(TO_STRING_NAME) && (superClass = rm.getContainingClass().getSuperClass()) != null && superClass.matches(NUMBER_CLS)) {
                context.report(SET_TEXT_I18N, node, context.getLocation(node), "Number formatting does not take into account locale settings. Consider using `String.format` instead.");
            }
        } else if (node instanceof BinaryExpression) {
            BinaryExpression expression = (BinaryExpression)node;
            if (expression.astOperator() == BinaryOperator.PLUS) {
                context.report(SET_TEXT_I18N, node, context.getLocation(node), "Do not concatenate text displayed with `setText`. Use resource string with placeholders.");
            }
            SetTextDetector.checkNode(context, (Node)expression.astLeft());
            SetTextDetector.checkNode(context, (Node)expression.astRight());
        }
    }
}

