/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.instrumentation.trace.Sampler;
import com.google.instrumentation.trace.Span;
import com.google.instrumentation.trace.SpanContext;
import com.google.instrumentation.trace.SpanId;
import com.google.instrumentation.trace.TraceId;
import java.util.List;
import javax.annotation.Nullable;

public final class Samplers {
    private static final Sampler ALWAYS_SAMPLE = new AlwaysSampleSampler();
    private static final Sampler NEVER_SAMPLE = new NeverSampleSampler();

    private Samplers() {
    }

    public static Sampler alwaysSample() {
        return ALWAYS_SAMPLE;
    }

    public static Sampler neverSample() {
        return NEVER_SAMPLE;
    }

    private static final class NeverSampleSampler
    extends Sampler {
        private NeverSampleSampler() {
        }

        @Override
        protected boolean shouldSample(@Nullable SpanContext parentContext, boolean remoteParent, TraceId traceId, SpanId spanId, String name, List<Span> parentLinks) {
            return false;
        }

        public String toString() {
            return "NeverSampleSampler";
        }
    }

    private static final class AlwaysSampleSampler
    extends Sampler {
        private AlwaysSampleSampler() {
        }

        @Override
        protected boolean shouldSample(@Nullable SpanContext parentContext, boolean remoteParent, TraceId traceId, SpanId spanId, String name, List<Span> parentLinks) {
            return true;
        }

        public String toString() {
            return "AlwaysSampleSampler";
        }
    }
}

