/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="UnnecessaryParentheses", summary="Unnecessary use of grouping parentheses", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, tags={"Style"})
public class UnnecessaryParentheses
extends BugChecker
implements BugChecker.ParenthesizedTreeMatcher {
    public Description matchParenthesized(ParenthesizedTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        if (state.getPath().getParentPath().getLeaf() instanceof StatementTree) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.requiresParentheses((ExpressionTree)expression, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(((JCTree)((Object)tree)).getStartPosition(), ((JCTree)((Object)expression)).getStartPosition(), "").replace(state.getEndPosition((Tree)expression), state.getEndPosition((Tree)tree), "").build());
    }
}

