/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.util.Context;
import com.sun.tools.sjavac.JavacState;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Option;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.options.SourceLocation;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.JavaFileManager;

public class SjavacImpl
implements Sjavac {
    @Override
    public Main.Result compile(String[] args) {
        Options options;
        try {
            options = Options.parseArgs(args);
        }
        catch (IllegalArgumentException e) {
            Log.error(e.getMessage());
            return Main.Result.CMDERR;
        }
        if (!SjavacImpl.validateOptions(options)) {
            return Main.Result.CMDERR;
        }
        if (SjavacImpl.srcDstOverlap(options.getSources(), options.getDestDir())) {
            return Main.Result.CMDERR;
        }
        if (!SjavacImpl.createIfMissing(options.getDestDir())) {
            return Main.Result.ERROR;
        }
        Path stateDir = options.getStateDir();
        if (stateDir != null && !SjavacImpl.createIfMissing(options.getStateDir())) {
            return Main.Result.ERROR;
        }
        Path gensrc = options.getGenSrcDir();
        if (gensrc != null && !SjavacImpl.createIfMissing(gensrc)) {
            return Main.Result.ERROR;
        }
        Path hdrdir = options.getHeaderDir();
        if (hdrdir != null && !SjavacImpl.createIfMissing(hdrdir)) {
            return Main.Result.ERROR;
        }
        if (stateDir == null) {
            Context context = new Context();
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            com.sun.tools.javac.util.Log.preRegister(context, printWriter);
            JavacFileManager.preRegister(context);
            String[] passThroughArgs = (String[])Stream.of(args).filter(arg -> !arg.startsWith(Option.SERVER.arg)).toArray(String[]::new);
            Main.Result result = new Main("javac", printWriter).compile(passThroughArgs, context);
            printWriter.flush();
            Util.getLines(strWriter.toString()).forEach(Log::error);
            JavaFileManager fileManager = context.get(JavaFileManager.class);
            if (fileManager instanceof JavacFileManager) {
                try {
                    ((JavacFileManager)fileManager).close();
                }
                catch (IOException es) {
                    throw new UncheckedIOException(es);
                }
            }
            return result;
        }
        JavacState javac_state = JavacState.load(options);
        HashMap<String, Transformer> suffixRules = new HashMap<String, Transformer>();
        suffixRules.putAll(javac_state.getJavaSuffixRule());
        suffixRules.putAll(options.getTranslationRules());
        HashMap<String, Module> modules = new HashMap<String, Module>();
        Module current_module = new Module("", "");
        modules.put("", current_module);
        try {
            boolean again;
            HashMap<String, Source> sources = new HashMap<String, Source>();
            SjavacImpl.findSourceFiles(options.getSources(), suffixRules.keySet(), sources, modules, current_module, options.isDefaultPackagePermitted(), false);
            if (sources.isEmpty()) {
                Log.error("Found nothing to compile!");
                return Main.Result.ERROR;
            }
            HashMap<String, Source> sources_to_link_to = new HashMap<String, Source>();
            ArrayList<SourceLocation> sourceResolutionLocations = new ArrayList<SourceLocation>();
            sourceResolutionLocations.addAll(options.getSources());
            sourceResolutionLocations.addAll(options.getSourceSearchPaths());
            SjavacImpl.findSourceFiles(sourceResolutionLocations, Collections.singleton(".java"), sources_to_link_to, modules, current_module, options.isDefaultPackagePermitted(), true);
            javac_state.now().flattenPackagesSourcesAndArtifacts(modules);
            javac_state.now().checkInternalState("checking sources", false, sources);
            javac_state.now().checkInternalState("checking linked sources", true, sources_to_link_to);
            javac_state.setVisibleSources(sources_to_link_to);
            int round = 0;
            SjavacImpl.printRound(round);
            javac_state.checkSourceStatus(false);
            javac_state.findAllArtifacts();
            if (!options.areUnidentifiedArtifactsPermitted()) {
                javac_state.removeUnidentifiedArtifacts();
            }
            javac_state.taintPackagesThatMissArtifacts();
            javac_state.taintPackagesDependingOnChangedClasspathPackages();
            javac_state.deleteClassArtifactsInTaintedPackages();
            javac_state.performCopying(Util.pathToFile(options.getDestDir()), suffixRules);
            javac_state.performTranslation(Util.pathToFile(gensrc), suffixRules);
            HashMap<String, Source> generated_sources = new HashMap<String, Source>();
            Source.scanRoot(Util.pathToFile(options.getGenSrcDir()), Util.set(".java"), Collections.emptyList(), Collections.emptyList(), generated_sources, modules, current_module, false, true, false);
            javac_state.now().flattenPackagesSourcesAndArtifacts(modules);
            javac_state.checkSourceStatus(true);
            javac_state.compareWithMakefileList(Util.pathToFile(options.getSourceReferenceList()));
            HashSet<String> recently_compiled = new HashSet<String>();
            boolean[] rc = new boolean[1];
            CompilationService compilationService = new CompilationService();
            do {
                if (round > 0) {
                    SjavacImpl.printRound(round);
                }
                javac_state.deleteClassArtifactsInTaintedPackages();
                again = javac_state.performJavaCompilations(compilationService, options, recently_compiled, rc);
                if (!rc[0]) {
                    Log.debug("Compilation failed.");
                    break;
                }
                if (!again) {
                    Log.debug("Nothing left to do.");
                }
                ++round;
            } while (again);
            Log.debug("No need to do another round.");
            if (rc[0]) {
                javac_state.save();
                javac_state.now().flattenArtifacts(modules);
                javac_state.removeSuperfluousArtifacts(recently_compiled);
            }
            return rc[0] ? Main.Result.OK : Main.Result.ERROR;
        }
        catch (ProblemException e) {
            Log.error(e.getMessage());
            Log.debug(e);
            return Main.Result.ERROR;
        }
        catch (Exception e) {
            Log.error(e);
            return Main.Result.ERROR;
        }
    }

    @Override
    public void shutdown() {
    }

    private static boolean validateOptions(Options options) {
        String err = null;
        if (options.getDestDir() == null) {
            err = "Please specify output directory.";
        } else if (options.isJavaFilesAmongJavacArgs()) {
            err = "Sjavac does not handle explicit compilation of single .java files.";
        } else if (!options.getImplicitPolicy().equals("none")) {
            err = "The only allowed setting for sjavac is -implicit:none";
        } else if (options.getSources().isEmpty() && options.getStateDir() != null) {
            err = "You have to specify -src when using --state-dir.";
        } else if (options.getTranslationRules().size() > 1 && options.getGenSrcDir() == null) {
            err = "You have translators but no gensrc dir (-s) specified!";
        }
        if (err != null) {
            Log.error(err);
        }
        return err == null;
    }

    private static boolean srcDstOverlap(List<SourceLocation> locs, Path dest) {
        for (SourceLocation loc : locs) {
            if (!SjavacImpl.isOverlapping(loc.getPath(), dest)) continue;
            Log.error("Source location " + loc.getPath() + " overlaps with destination " + dest);
            return true;
        }
        return false;
    }

    private static boolean isOverlapping(Path p1, Path p2) {
        return (p1 = p1.toAbsolutePath().normalize()).startsWith(p2 = p2.toAbsolutePath().normalize()) || p2.startsWith(p1);
    }

    private static boolean createIfMissing(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return true;
        }
        if (Files.exists(dir, new LinkOption[0])) {
            Log.error(dir + " is not a directory.");
            return false;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Log.error("Could not create directory: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static void findSourceFiles(List<SourceLocation> sourceLocations, Set<String> sourceTypes, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean permitSourcesInDefaultPackage, boolean inLinksrc) throws IOException {
        for (SourceLocation source : sourceLocations) {
            source.findSourceFiles(sourceTypes, foundFiles, foundModules, currentModule, permitSourcesInDefaultPackage, inLinksrc);
        }
    }

    private static void printRound(int round) {
        Log.debug("****************************************");
        Log.debug("* Round " + round + "                              *");
        Log.debug("****************************************");
    }
}

