/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.model;

public enum TurbineVisibility {
    PUBLIC(3, 1),
    PROTECTED(2, 4),
    PACKAGE(1, 0),
    PRIVATE(0, 2);

    private final int level;
    private final int flag;
    public static final int VISIBILITY_MASK = 7;

    private TurbineVisibility(int level, int flag) {
        this.level = level;
        this.flag = flag;
    }

    public boolean moreVisible(TurbineVisibility other) {
        return this.level > other.level;
    }

    public int flag() {
        return this.flag;
    }

    public static TurbineVisibility fromAccess(int access) {
        if ((access & 1) == 1) {
            return PUBLIC;
        }
        if ((access & 4) == 4) {
            return PROTECTED;
        }
        if ((access & 2) == 2) {
            return PRIVATE;
        }
        return PACKAGE;
    }

    public int setAccess(int access) {
        access &= 0xFFFFFFF8;
        return access |= this.flag();
    }
}

