/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ErrorProneFlags
implements Serializable {
    public static final String PREFIX = "-XepOpt:";
    private final ImmutableMap<String, String> flagsMap;

    public static ErrorProneFlags empty() {
        return new ErrorProneFlags((ImmutableMap<String, String>)ImmutableMap.of());
    }

    public static ErrorProneFlags fromMap(Map<String, String> flagsMap) {
        return new ErrorProneFlags((ImmutableMap<String, String>)ImmutableMap.copyOf(flagsMap));
    }

    private ErrorProneFlags(ImmutableMap<String, String> flagsMap) {
        this.flagsMap = flagsMap;
    }

    public ImmutableMap<String, String> getFlagsMap() {
        return ImmutableMap.copyOf(this.flagsMap);
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.flagsMap.get((Object)key));
    }

    public Optional<Boolean> getBoolean(String key) {
        return this.get(key).map(ErrorProneFlags::parseBoolean);
    }

    private static boolean parseBoolean(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Error Prone flag value %s could not be parsed as a boolean.", value));
    }

    public Optional<Integer> getInteger(String key) {
        return this.get(key).map(Integer::valueOf);
    }

    public Optional<ImmutableList<String>> getList(String key) {
        return this.get(key).map(v -> ImmutableList.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)v)));
    }

    public boolean isEmpty() {
        return this.flagsMap.isEmpty();
    }

    @CheckReturnValue
    public ErrorProneFlags plus(ErrorProneFlags other) {
        HashMap<String, String> combinedMaps = new HashMap<String, String>((Map<String, String>)this.getFlagsMap());
        combinedMaps.putAll((Map<String, String>)other.getFlagsMap());
        return ErrorProneFlags.fromMap(combinedMaps);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final HashMap<String, String> flagsMap = new HashMap();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder parseFlag(String flag) {
            Preconditions.checkArgument((boolean)flag.startsWith(ErrorProneFlags.PREFIX));
            String remaining = flag.substring(ErrorProneFlags.PREFIX.length());
            String[] parts = remaining.split("=", 2);
            String key = parts[0];
            String value = parts.length < 2 ? "true" : parts[1];
            this.putFlag(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putFlag(String key, String value) {
            this.flagsMap.put(key, value);
            return this;
        }

        public ErrorProneFlags build() {
            return ErrorProneFlags.fromMap(this.flagsMap);
        }
    }
}

