/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class StreamSubject
extends Subject<StreamSubject, Stream<?>> {
    private final List<?> actualList;

    private StreamSubject(FailureMetadata failureMetadata, @NullableDecl Stream<?> stream) {
        super(failureMetadata, stream);
        this.actualList = stream == null ? null : (List)stream.collect(Collectors.toCollection(ArrayList::new));
    }

    protected String actualCustomStringRepresentation() {
        return String.valueOf(this.actualList);
    }

    public static Subject.Factory<StreamSubject, Stream<?>> streams() {
        return (metadata, subject) -> new StreamSubject(metadata, (Stream<?>)subject);
    }

    public void isEmpty() {
        this.check().that(this.actualList).isEmpty();
    }

    public void isNotEmpty() {
        this.check().that(this.actualList).isNotEmpty();
    }

    public void hasSize(int expectedSize) {
        this.check().that(this.actualList).hasSize(expectedSize);
    }

    public void contains(@NullableDecl Object element) {
        this.check().that(this.actualList).contains(element);
    }

    public void doesNotContain(@NullableDecl Object element) {
        this.check().that(this.actualList).doesNotContain(element);
    }

    public void containsNoDuplicates() {
        this.check().that(this.actualList).containsNoDuplicates();
    }

    public void containsAnyOf(@NullableDecl Object first, @NullableDecl Object second, Object ... rest) {
        this.check().that(this.actualList).containsAnyOf(first, second, rest);
    }

    public void containsAnyIn(Iterable<?> expected) {
        this.check().that(this.actualList).containsAnyIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllOf(@NullableDecl Object first, @NullableDecl Object second, Object ... rest) {
        return this.check().that(this.actualList).containsAllOf(first, second, rest);
    }

    @CanIgnoreReturnValue
    public Ordered containsAllIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsAllIn(expected);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(Object ... varargs) {
        return this.check().that(this.actualList).containsExactly(varargs);
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.check().that(this.actualList).containsExactlyElementsIn(expected);
    }

    public void containsNoneOf(@NullableDecl Object first, @NullableDecl Object second, Object ... rest) {
        this.check().that(this.actualList).containsNoneOf(first, second, rest);
    }

    public void containsNoneIn(Iterable<?> excluded) {
        this.check().that(this.actualList).containsNoneIn(excluded);
    }

    private void isInStrictOrder() {
        this.check().that(this.actualList).isStrictlyOrdered();
    }

    private void isInStrictOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isStrictlyOrdered(comparator);
    }

    private void isInOrder() {
        this.check().that(this.actualList).isOrdered();
    }

    private void isInOrder(Comparator<?> comparator) {
        this.check().that(this.actualList).isOrdered(comparator);
    }
}

