/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import java.util.Optional;

@BugPattern(name="OverrideThrowableToString", summary="To return a custom message with a Throwable class, one should override getMessage() instead of toString() for Throwable.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class OverrideThrowableToString
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState visitorState) {
        Optional<Tree> methodTree;
        Symbol throwableClass = visitorState.getSymbolFromString("java.lang.Throwable");
        if (Objects.equals(ASTHelpers.getSymbol((Tree)classTree.getExtendsClause()), throwableClass) && (methodTree = classTree.getMembers().stream().filter(m -> m instanceof MethodTree && ((MethodTree)m).getName().contentEquals("toString")).findFirst()).isPresent()) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            MethodTree tree = (MethodTree)methodTree.get();
            if (!tree.getParameters().isEmpty()) {
                return Description.NO_MATCH;
            }
            String newTree = tree.getModifiers().toString().replaceAll("@Override[(][)]", "@Override") + "String getMessage()\n" + visitorState.getSourceForNode((Tree)tree.getBody());
            builder.replace((Tree)tree, newTree);
            return this.describeMatch(classTree, (Fix)builder.build());
        }
        return Description.NO_MATCH;
    }
}

