/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Platform;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class DoubleSubject
extends ComparableSubject<DoubleSubject, Double> {
    private static final long NEG_ZERO_BITS = Double.doubleToLongBits(-0.0);

    DoubleSubject(FailureMetadata metadata, @NullableDecl Double actual) {
        super(metadata, actual);
    }

    public TolerantDoubleComparison isWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = (Double)DoubleSubject.this.actual();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object)tolerance, (Object)expected);
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.equalWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithoutActual(Fact.fact("expected", Platform.doubleToString(expected)), DoubleSubject.this.butWas(), Fact.fact("outside tolerance", Platform.doubleToString(tolerance)));
                }
            }
        };
    }

    public TolerantDoubleComparison isNotWithin(final double tolerance) {
        return new TolerantDoubleComparison(){

            @Override
            public void of(double expected) {
                Double actual = (Double)DoubleSubject.this.actual();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. tolerance=%s expected=%s", (Object)tolerance, (Object)expected);
                DoubleSubject.checkTolerance(tolerance);
                if (!MathUtil.notEqualWithinTolerance(actual, expected, tolerance)) {
                    DoubleSubject.this.failWithoutActual(Fact.fact("expected not to be", Platform.doubleToString(expected)), DoubleSubject.this.butWas(), Fact.fact("within tolerance", Platform.doubleToString(tolerance)));
                }
            }
        };
    }

    public final void isEqualTo(@NullableDecl Double other) {
        super.isEqualTo(other);
    }

    public final void isNotEqualTo(@NullableDecl Double other) {
        super.isNotEqualTo(other);
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(Double other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    static void checkTolerance(double tolerance) {
        Preconditions.checkArgument((!Double.isNaN(tolerance) ? 1 : 0) != 0, (Object)"tolerance cannot be NaN");
        Preconditions.checkArgument((tolerance >= 0.0 ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object)tolerance);
        Preconditions.checkArgument((Double.doubleToLongBits(tolerance) != NEG_ZERO_BITS ? 1 : 0) != 0, (String)"tolerance (%s) cannot be negative", (Object)tolerance);
        Preconditions.checkArgument((tolerance != Double.POSITIVE_INFINITY ? 1 : 0) != 0, (Object)"tolerance cannot be POSITIVE_INFINITY");
    }

    public final void isZero() {
        if (this.actual() == null || (Double)this.actual() != 0.0) {
            this.failWithActual(Fact.simpleFact("expected zero"), new Fact[0]);
        }
    }

    public final void isNonZero() {
        if (this.actual() == null) {
            this.failWithActual(Fact.simpleFact("expected a double other than zero"), new Fact[0]);
        } else if ((Double)this.actual() == 0.0) {
            this.failWithActual(Fact.simpleFact("expected not to be zero"), new Fact[0]);
        }
    }

    public final void isPositiveInfinity() {
        this.isEqualTo(Double.POSITIVE_INFINITY);
    }

    public final void isNegativeInfinity() {
        this.isEqualTo(Double.NEGATIVE_INFINITY);
    }

    public final void isNaN() {
        this.isEqualTo(Double.NaN);
    }

    public final void isFinite() {
        if (this.actual() == null || ((Double)this.actual()).isNaN() || ((Double)this.actual()).isInfinite()) {
            this.failWithActual(Fact.simpleFact("expected to be finite"), new Fact[0]);
        }
    }

    public final void isNotNaN() {
        if (this.actual() == null) {
            this.failWithActual(Fact.simpleFact("expected a double other than NaN"), new Fact[0]);
        } else {
            this.isNotEqualTo(Double.NaN);
        }
    }

    public static abstract class TolerantDoubleComparison {
        private TolerantDoubleComparison() {
        }

        public abstract void of(double var1);

        @Deprecated
        public boolean equals(@NullableDecl Object o) {
            throw new UnsupportedOperationException("If you meant to compare doubles, use .of(double) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

