/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1771")
public final class RoundRobinLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final RoundRobinLoadBalancerFactory INSTANCE = new RoundRobinLoadBalancerFactory();

    private RoundRobinLoadBalancerFactory() {
    }

    public static RoundRobinLoadBalancerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RoundRobinLoadBalancer(helper);
    }

    @VisibleForTesting
    static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private static final AtomicIntegerFieldUpdater<Picker> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(Picker.class, "index");
        @Nullable
        private final Status status;
        private final List<LoadBalancer.Subchannel> list;
        private volatile int index = -1;

        Picker(List<LoadBalancer.Subchannel> list, @Nullable Status status) {
            this.list = list;
            this.status = status;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.list.size() > 0) {
                return LoadBalancer.PickResult.withSubchannel(this.nextSubchannel());
            }
            if (this.status != null) {
                return LoadBalancer.PickResult.withError(this.status);
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        private LoadBalancer.Subchannel nextSubchannel() {
            if (this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            int size = this.list.size();
            int i = indexUpdater.incrementAndGet(this);
            if (i >= size) {
                int oldi = i;
                indexUpdater.compareAndSet(this, oldi, i %= size);
            }
            return this.list.get(i);
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @VisibleForTesting
        Status getStatus() {
            return this.status;
        }
    }

    @VisibleForTesting
    static final class RoundRobinLoadBalancer
    extends LoadBalancer {
        @VisibleForTesting
        static final Attributes.Key<Ref<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of("state-info");
        private final LoadBalancer.Helper helper;
        private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();

        RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
            Set<EquivalentAddressGroup> latestAddrs = RoundRobinLoadBalancer.stripAttrs(servers);
            Set<EquivalentAddressGroup> addedAddrs = RoundRobinLoadBalancer.setsDifference(latestAddrs, currentAddrs);
            Set<EquivalentAddressGroup> removedAddrs = RoundRobinLoadBalancer.setsDifference(currentAddrs, latestAddrs);
            for (EquivalentAddressGroup addressGroup : addedAddrs) {
                Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new Ref<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).build();
                LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)this.helper.createSubchannel(addressGroup, subchannelAttrs), (Object)"subchannel");
                this.subchannels.put(addressGroup, subchannel);
                subchannel.requestConnection();
            }
            for (EquivalentAddressGroup addressGroup : removedAddrs) {
                LoadBalancer.Subchannel subchannel = this.subchannels.remove(addressGroup);
                subchannel.shutdown();
            }
            this.updateBalancingState(this.getAggregatedState(), this.getAggregatedError());
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            if (this.subchannels.get(subchannel.getAddresses()) != subchannel) {
                return;
            }
            if (stateInfo.getState() == ConnectivityState.IDLE) {
                subchannel.requestConnection();
            }
            RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value = stateInfo;
            this.updateBalancingState(this.getAggregatedState(), this.getAggregatedError());
        }

        @Override
        public void shutdown() {
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                subchannel.shutdown();
            }
        }

        private void updateBalancingState(ConnectivityState state, Status error) {
            List<LoadBalancer.Subchannel> activeList = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
            this.helper.updateBalancingState(state, new Picker(activeList, error));
        }

        private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> subchannels) {
            ArrayList<LoadBalancer.Subchannel> readySubchannels = new ArrayList<LoadBalancer.Subchannel>(subchannels.size());
            for (LoadBalancer.Subchannel subchannel : subchannels) {
                if (((ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState() != ConnectivityState.READY) continue;
                readySubchannels.add(subchannel);
            }
            return readySubchannels;
        }

        private static Set<EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
            HashSet<EquivalentAddressGroup> addrs = new HashSet<EquivalentAddressGroup>(groupList.size());
            for (EquivalentAddressGroup group : groupList) {
                addrs.add(new EquivalentAddressGroup(group.getAddresses()));
            }
            return addrs;
        }

        @Nullable
        private Status getAggregatedError() {
            Status status = null;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value;
                if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) {
                    return null;
                }
                status = stateInfo.getStatus();
            }
            return status;
        }

        private ConnectivityState getAggregatedState() {
            EnumSet<ConnectivityState> states = EnumSet.noneOf(ConnectivityState.class);
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                states.add(((ConnectivityStateInfo)RoundRobinLoadBalancer.getSubchannelStateInfoRef((LoadBalancer.Subchannel)subchannel).value).getState());
            }
            if (states.contains((Object)ConnectivityState.READY)) {
                return ConnectivityState.READY;
            }
            if (states.contains((Object)ConnectivityState.CONNECTING)) {
                return ConnectivityState.CONNECTING;
            }
            if (states.contains((Object)ConnectivityState.IDLE)) {
                return ConnectivityState.CONNECTING;
            }
            return ConnectivityState.TRANSIENT_FAILURE;
        }

        @VisibleForTesting
        Collection<LoadBalancer.Subchannel> getSubchannels() {
            return this.subchannels.values();
        }

        private static Ref<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
            return (Ref)Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), (Object)"STATE_INFO");
        }

        private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
            HashSet<T> aCopy = new HashSet<T>(a);
            aCopy.removeAll(b);
            return aCopy;
        }
    }

    @VisibleForTesting
    static final class Ref<T> {
        T value;

        Ref(T value) {
            this.value = value;
        }
    }
}

