/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(name="ThreadLocalUsage", summary="ThreadLocals should be stored in static fields", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ThreadLocalUsage
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_THREAD_LOCAL = MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf((String)"java.lang.ThreadLocal"));
    private static final ImmutableSet<String> WELL_KNOWN_TYPES = ImmutableSet.of((Object)"java.lang.String", (Object)"java.lang.Boolean", (Object)"java.lang.Long", (Object)"java.lang.Integer", (Object)"java.lang.Short", (Object)"java.lang.Character", (Object[])new String[]{"java.lang.Float", "java.lang.Double"});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!NEW_THREAD_LOCAL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (this.wellKnownTypeArgument(tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof VariableTree)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)((VariableTree)parent));
        if (sym != null && sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (Streams.stream((Iterable)state.getPath()).filter(ClassTree.class::isInstance).map(ClassTree.class::cast).anyMatch(c -> {
            if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)ASTHelpers.getSymbol((ClassTree)c), (String)"Singleton")) {
                return true;
            }
            Type scopeType = state.getTypeFromString("com.google.inject.Scope");
            return ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)c), (Type)scopeType, (VisitorState)state);
        })) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private boolean wellKnownTypeArgument(NewClassTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return false;
        }
        type = state.getTypes().asSuper(type, state.getSymbolFromString("java.lang.ThreadLocal"));
        if (type == null) {
            return false;
        }
        if (type.getTypeArguments().isEmpty()) {
            return false;
        }
        Type argType = (Type)Iterables.getOnlyElement(type.getTypeArguments());
        if (WELL_KNOWN_TYPES.contains((Object)argType.asElement().getQualifiedName().toString())) {
            return true;
        }
        return ASTHelpers.isSubtype((Type)argType, (Type)state.getTypeFromString("java.text.DateFormat"), (VisitorState)state);
    }
}

