/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.LineMap;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import java.util.Objects;

public class TurbineDiagnostic {
    private final TurbineError.ErrorKind kind;
    private final String diagnostic;
    private final ImmutableList<Object> args;

    private TurbineDiagnostic(TurbineError.ErrorKind kind, String diagnostic, ImmutableList<Object> args) {
        this.kind = Objects.requireNonNull(kind);
        this.diagnostic = Objects.requireNonNull(diagnostic);
        this.args = Objects.requireNonNull(args);
    }

    public TurbineError.ErrorKind kind() {
        return this.kind;
    }

    public String diagnostic() {
        return this.diagnostic;
    }

    public ImmutableList<Object> args() {
        return this.args;
    }

    private static TurbineDiagnostic create(TurbineError.ErrorKind kind, String diagnostic, ImmutableList<Object> args) {
        switch (kind) {
            case SYMBOL_NOT_FOUND: {
                Preconditions.checkArgument((args.size() == 1 && Iterables.getOnlyElement(args) instanceof ClassSymbol ? 1 : 0) != 0, (String)"diagnostic (%s) has invalid argument args %s", (Object)diagnostic, args);
                break;
            }
        }
        return new TurbineDiagnostic(kind, diagnostic, args);
    }

    public static TurbineDiagnostic format(SourceFile source, TurbineError.ErrorKind kind, Object ... args) {
        String path = (String)MoreObjects.firstNonNull((Object)source.path(), (Object)"<>");
        String message = kind.format(args);
        String diagnostic = path + ": error: " + message.trim() + System.lineSeparator();
        return TurbineDiagnostic.create(kind, diagnostic, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args));
    }

    public static TurbineDiagnostic format(SourceFile source, int position, TurbineError.ErrorKind kind, Object ... args) {
        String path = (String)MoreObjects.firstNonNull((Object)source.path(), (Object)"<>");
        LineMap lineMap = LineMap.create(source.source());
        int lineNumber = lineMap.lineNumber(position);
        int column = lineMap.column(position);
        String message = kind.format(args);
        StringBuilder sb = new StringBuilder(path).append(":");
        sb.append(lineNumber).append(": error: ");
        sb.append(message.trim()).append(System.lineSeparator());
        sb.append(CharMatcher.breakingWhitespace().trimTrailingFrom((CharSequence)lineMap.line(position))).append(System.lineSeparator());
        sb.append(Strings.repeat((String)" ", (int)column)).append('^');
        String diagnostic = sb.toString();
        return TurbineDiagnostic.create(kind, diagnostic, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diagnostic, this.kind});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TurbineDiagnostic)) {
            return false;
        }
        TurbineDiagnostic that = (TurbineDiagnostic)obj;
        return this.diagnostic.equals(that.diagnostic) && this.kind.equals((Object)that.kind);
    }
}

