/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.ast.Ast;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.Statement;
import lombok.ast.TypeMember;
import lombok.ast.TypeReference;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableReference;
import lombok.ast.grammar.Source;

public class Template<T extends Node> {
    private final T node;
    private int location;
    private Node responsible;
    private List<ReplacementOrder> replacements = new ArrayList<ReplacementOrder>();
    private int replacementsPointer = 0;
    private final AstVisitor visitor = new ForwardingAstVisitor(){

        @Override
        public boolean visitNode(Node node) {
            node.setPosition(new Position(Template.this.location, Template.this.location, Template.this.responsible));
            return false;
        }

        @Override
        public void endVisit(Node node) {
            node.setPosition(new Position(node.getPosition().getStart(), Template.this.location, Template.this.responsible));
        }

        private ReplacementOrder currentOrder() {
            return Template.this.replacementsPointer < Template.this.replacements.size() ? (ReplacementOrder)Template.this.replacements.get(Template.this.replacementsPointer) : null;
        }

        @Override
        public boolean visitIdentifier(Identifier node) {
            ReplacementOrder order = this.currentOrder();
            if (order != null && order.identifierToReplace != null && order.identifierToReplace.equals(node.astValue())) {
                Node replacement = order.replacement.get(0);
                int startLoc = order.position == null ? Template.this.location : order.position.getStart();
                int endLoc = order.position == null ? Template.this.location : order.position.getEnd();
                replacement.setPosition(new Position(startLoc, endLoc, Template.this.responsible));
                Template.this.location = endLoc;
                node.replace(replacement);
                Template.this.replacementsPointer++;
                return true;
            }
            return this.visitNode(node);
        }

        @Override
        public boolean visitLabelledStatement(LabelledStatement node) {
            ReplacementOrder order = this.currentOrder();
            if (order != null && order.statementToReplace.equals(node.astLabel().astValue())) {
                int endLoc;
                int startLoc;
                if (!(node.rawStatement() instanceof EmptyStatement)) {
                    throw new IllegalStateException("Placeholder statements in templates should be of the form: \"labelName: ;\" - i.e. a labelled empty statement");
                }
                if (order.position == null) {
                    startLoc = order.replacement.isEmpty() || order.replacement.get(0).getPosition().getStart() < 0 ? Template.this.location : order.replacement.get(0).getPosition().getStart();
                    endLoc = order.replacement.isEmpty() || order.replacement.get(order.replacement.size() - 1).getPosition().getEnd() < 0 ? Template.this.location : order.replacement.get(order.replacement.size() - 1).getPosition().getEnd();
                } else {
                    startLoc = order.position.getStart();
                    endLoc = order.position.getEnd();
                }
                switch (order.replacement.size()) {
                    case 0: {
                        node.unparent();
                        break;
                    }
                    case 1: {
                        Node replacement = order.replacement.get(0);
                        if (replacement.getPosition().isUnplaced()) {
                            Ast.setAllPositions(replacement, new Position(startLoc, endLoc, Template.this.responsible));
                        }
                        node.replace(replacement);
                        break;
                    }
                    default: {
                        Block b = node.upToBlock();
                        if (b == null) {
                            throw new IllegalStateException("Replacing one placeholder statement with multiple statements is legal only if the placeholder is in a block");
                        }
                        b.rawContents().addAfter(node, order.replacement.toArray(new Node[0]));
                        node.unparent();
                        for (Node node2 : order.replacement) {
                            if (!node2.getPosition().isUnplaced()) continue;
                            Ast.setAllPositions(node2, new Position(startLoc, endLoc, Template.this.responsible));
                        }
                    }
                }
                Template.this.replacementsPointer++;
                Template.this.location = endLoc;
                return true;
            }
            return this.visitNode(node);
        }

        @Override
        public boolean visitVariableReference(VariableReference node) {
            ReplacementOrder order = this.currentOrder();
            if (order != null && order.expressionToReplace.equals(node.astIdentifier().astValue())) {
                int endLoc;
                int startLoc;
                Node replacement = order.replacement.get(0);
                if (order.position == null) {
                    startLoc = order.replacement.isEmpty() || replacement.getPosition().getStart() < 0 ? Template.this.location : replacement.getPosition().getStart();
                    endLoc = order.replacement.isEmpty() || replacement.getPosition().getEnd() < 0 ? Template.this.location : replacement.getPosition().getEnd();
                } else {
                    startLoc = order.position.getStart();
                    endLoc = order.position.getEnd();
                }
                if (replacement.getPosition().isUnplaced()) {
                    Ast.setAllPositions(replacement, new Position(startLoc, endLoc, Template.this.responsible));
                }
                Template.this.location = endLoc;
                node.replace(replacement);
                Template.this.replacementsPointer++;
                return true;
            }
            return this.visitNode(node);
        }

        @Override
        public boolean visitTypeReference(TypeReference node) {
            ReplacementOrder order = this.currentOrder();
            if (order != null && node.astParts().size() == 1 && node.astParts().last().rawTypeArguments().isEmpty() && node.astParts().last().astIdentifier().astValue().equals(order.typeReferenceToReplace)) {
                int endLoc;
                int startLoc;
                Node replacement = order.replacement.get(0);
                if (order.position == null) {
                    startLoc = order.replacement.isEmpty() || replacement.getPosition().getStart() < 0 ? Template.this.location : replacement.getPosition().getStart();
                    endLoc = order.replacement.isEmpty() || replacement.getPosition().getEnd() < 0 ? Template.this.location : replacement.getPosition().getEnd();
                } else {
                    startLoc = order.position.getStart();
                    endLoc = order.position.getEnd();
                }
                if (replacement.getPosition().isUnplaced()) {
                    Ast.setAllPositions(replacement, new Position(startLoc, endLoc, Template.this.responsible));
                }
                Template.this.location = endLoc;
                node.replace(replacement);
                Template.this.replacementsPointer++;
                return true;
            }
            return this.visitNode(node);
        }
    };

    private static <N extends Node> N process(Source s, String name, Class<N> type) {
        if (!s.getProblems().isEmpty()) {
            throw new AstException(null, "Can't parse snippet: " + s.getProblems().get(0).getMessage());
        }
        if (s.getNodes().isEmpty()) {
            return null;
        }
        if (s.getNodes().size() > 1) {
            throw new AstException(null, "Can't parse snippet: more than one " + name + " in snippet");
        }
        Node n = s.getNodes().get(0);
        if (type.isInstance(n)) {
            return (N)((Node)type.cast(n));
        }
        throw new AstException(null, "Can't parse snippet: Not a " + name);
    }

    public static TypeMember parseMember(String source) throws AstException {
        Source s = new Source(source, "memberSnippet");
        s.parseMember();
        return Template.process(s, "type member", TypeMember.class);
    }

    public static MethodDeclaration parseMethod(String source) throws AstException {
        Source s = new Source(source, "methodSnippet");
        s.parseMember();
        return Template.process(s, "method", MethodDeclaration.class);
    }

    public static ConstructorDeclaration parseConstructor(String source) throws AstException {
        Source s = new Source(source, "constructorSnippet");
        s.parseMember();
        return Template.process(s, "constructor", ConstructorDeclaration.class);
    }

    public static VariableDeclaration parseField(String source) throws AstException {
        Source s = new Source(source, "fieldSnippet");
        s.parseMember();
        return Template.process(s, "field", VariableDeclaration.class);
    }

    public static VariableDefinition parseVariableDefinition(String source) throws AstException {
        Source s = new Source(source, "vardefSnippet");
        s.parseMember();
        return Template.process(s, "vardef", VariableDefinition.class);
    }

    public static Statement parseStatement(String source) throws AstException {
        Source s = new Source(source, "statementSnippet");
        s.parseStatement();
        return Template.process(s, "statement", Statement.class);
    }

    public static Expression parseExpression(String source) throws AstException {
        Source s = new Source(source, "expressionSnippet");
        s.parseExpression();
        return Template.process(s, "expression", Expression.class);
    }

    public static <N extends Node> Template<N> of(N source) throws AstException {
        return new Template<Node>(source.copy());
    }

    private Template(T node) {
        this.node = node;
    }

    public Template<T> setStartPosition(int location) {
        this.location = location;
        return this;
    }

    public Template<T> setResponsibleNode(Node responsible) {
        this.responsible = responsible;
        return this;
    }

    public Template<T> replaceIdentifier(String placeholder, String replacement, Position p) {
        this.replacements.add(ReplacementOrder.forIdentifier(placeholder, replacement, p));
        return this;
    }

    public Template<T> replaceIdentifier(String placeholder, String replacement) {
        return this.replaceIdentifier(placeholder, replacement, null);
    }

    public Template<T> replaceStatement(String placeholder, Node replacement, Position p) {
        this.replacements.add(ReplacementOrder.forStatement(placeholder, replacement == null ? Collections.emptyList() : Collections.singletonList(replacement), p));
        return this;
    }

    public Template<T> replaceStatement(String placeholder, Node replacement) {
        return this.replaceStatement(placeholder, replacement, null);
    }

    public Template<T> replaceStatement(String placeholder, List<? extends Node> replacement, Position p) {
        this.replacements.add(ReplacementOrder.forStatement(placeholder, replacement, p));
        return this;
    }

    public Template<T> replaceStatement(String placeholder, List<? extends Node> replacement) {
        return this.replaceStatement(placeholder, replacement, null);
    }

    public Template<T> replaceExpression(String placeholder, Node replacement, Position p) {
        this.replacements.add(ReplacementOrder.forExpression(placeholder, replacement, p));
        return this;
    }

    public Template<T> replaceExpression(String placeholder, Node replacement) {
        return this.replaceExpression(placeholder, replacement, null);
    }

    public Template<T> replaceTypeReference(String placeholder, Node replacement, Position p) {
        this.replacements.add(ReplacementOrder.forTypeReference(placeholder, replacement, p));
        return this;
    }

    public Template<T> replaceTypeReference(String placeholder, Node replacement) {
        return this.replaceTypeReference(placeholder, replacement, null);
    }

    public T finish() {
        this.node.accept(this.visitor);
        return this.node;
    }

    private static class ReplacementOrder {
        String identifierToReplace;
        String statementToReplace;
        String expressionToReplace;
        String typeReferenceToReplace;
        List<? extends Node> replacement;
        Position position;

        private ReplacementOrder() {
        }

        static ReplacementOrder forIdentifier(String identifier, String newValue, Position position) {
            ReplacementOrder order = new ReplacementOrder();
            order.identifierToReplace = identifier;
            order.replacement = Collections.singletonList(newValue == null ? null : Identifier.of(newValue));
            order.position = position;
            return order;
        }

        static ReplacementOrder forStatement(String label, List<? extends Node> replacements, Position position) {
            ReplacementOrder order = new ReplacementOrder();
            order.statementToReplace = label;
            order.replacement = replacements == null ? Collections.emptyList() : replacements;
            order.position = position;
            return order;
        }

        static ReplacementOrder forExpression(String identifier, Node replacement, Position position) {
            ReplacementOrder order = new ReplacementOrder();
            order.expressionToReplace = identifier;
            order.replacement = Collections.singletonList(replacement);
            order.position = position;
            return order;
        }

        static ReplacementOrder forTypeReference(String identifier, Node replacement, Position position) {
            ReplacementOrder order = new ReplacementOrder();
            order.typeReferenceToReplace = identifier;
            order.replacement = Collections.singletonList(replacement);
            order.position = position;
            return order;
        }
    }
}

