/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.ast.AbstractNode;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;

class ListAccessor<T extends Node, P extends Node> {
    private List<AbstractNode> list;
    private final AbstractNode parent;
    private final Class<T> tClass;
    private final String listName;
    private final P returnAsParent;
    private boolean escaped;
    private RawListAccessor<T, P> raw = new RawListAccessor<T, P>(){

        @Override
        public P up() {
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public Node owner() {
            return ListAccessor.this.parent;
        }

        @Override
        public void clear() {
            if (ListAccessor.this.escaped) {
                ListAccessor.this.list = new ArrayList();
                ListAccessor.this.escaped = false;
            } else {
                ListAccessor.this.list.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return ListAccessor.this.list.isEmpty();
        }

        @Override
        public int size() {
            return ListAccessor.this.list.size();
        }

        @Override
        public Node first() {
            try {
                return (Node)ListAccessor.this.list.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public Node last() {
            try {
                return (Node)ListAccessor.this.list.get(ListAccessor.this.list.size() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public boolean contains(Node source) {
            if (source == null) {
                return false;
            }
            if (source.getParent() != ListAccessor.this.parent) {
                return false;
            }
            for (int i = 0; i < ListAccessor.this.list.size(); ++i) {
                if (ListAccessor.this.list.get(i) != source) continue;
                return true;
            }
            return false;
        }

        @Override
        public P migrateAllFrom(RawListAccessor<?, ?> otherList) {
            while (!otherList.isEmpty()) {
                AbstractNode n = (AbstractNode)otherList.first();
                otherList.remove(n);
                this.addToEnd(n);
            }
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public P addToStart(Node ... node) {
            for (int i = node.length - 1; i >= 0; --i) {
                AbstractNode child = (AbstractNode)node[i];
                if (child == null) continue;
                ListAccessor.this.parent.adopt(child);
                ListAccessor.this.fixEscaped();
                ListAccessor.this.list.add(0, child);
            }
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public P addToEnd(Node ... node) {
            for (Node n : node) {
                AbstractNode child = (AbstractNode)n;
                if (child == null) continue;
                ListAccessor.this.parent.adopt(child);
                ListAccessor.this.fixEscaped();
                ListAccessor.this.list.add(child);
            }
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public P addBefore(Node ref, Node ... node) {
            if (ref == null) {
                throw new NullPointerException("ref");
            }
            ListAccessor.this.parent.ensureParentage((AbstractNode)ref);
            for (int i = 0; i < ListAccessor.this.list.size(); ++i) {
                if (ListAccessor.this.list.get(i) != ref) continue;
                int j = 0;
                for (Node n : node) {
                    AbstractNode child = (AbstractNode)n;
                    if (child == null) continue;
                    child.ensureParentless();
                    ListAccessor.this.parent.adopt(child);
                    ListAccessor.this.fixEscaped();
                    ListAccessor.this.list.add(i + j, child);
                    ++j;
                }
                return ListAccessor.this.returnAsParent;
            }
            throw new IllegalStateException(ListAccessor.this.listName + " does not contain: " + ref);
        }

        @Override
        public P addAfter(Node ref, Node ... node) {
            if (ref == null) {
                throw new NullPointerException("ref");
            }
            ListAccessor.this.parent.ensureParentage((AbstractNode)ref);
            for (int i = 0; i < ListAccessor.this.list.size(); ++i) {
                if (ListAccessor.this.list.get(i) != ref) continue;
                int j = 0;
                for (Node n : node) {
                    AbstractNode child = (AbstractNode)n;
                    if (child == null) continue;
                    child.ensureParentless();
                    ListAccessor.this.parent.adopt(child);
                    ListAccessor.this.fixEscaped();
                    ListAccessor.this.list.add(i + j + 1, child);
                    ++j;
                }
                return ListAccessor.this.returnAsParent;
            }
            throw new IllegalStateException(ListAccessor.this.listName + " does not contain: " + ref);
        }

        @Override
        public boolean replace(Node source, Node replacement) throws NoSuchElementException {
            if (source == null) {
                return false;
            }
            if (source.getParent() != ListAccessor.this.parent) {
                return false;
            }
            if (replacement != null) {
                ((AbstractNode)replacement).ensureParentless();
            }
            for (int i = 0; i < ListAccessor.this.list.size(); ++i) {
                if (ListAccessor.this.list.get(i) != source) continue;
                ListAccessor.this.parent.disown((AbstractNode)source);
                try {
                    if (replacement != null) {
                        ListAccessor.this.parent.adopt((AbstractNode)replacement);
                    }
                }
                catch (IllegalStateException e) {
                    ListAccessor.this.parent.adopt((AbstractNode)source);
                    throw e;
                }
                ListAccessor.this.fixEscaped();
                if (replacement == null) {
                    ListAccessor.this.list.remove(i);
                } else {
                    ListAccessor.this.list.set(i, (AbstractNode)replacement);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Node source) {
            if (source == null) {
                return false;
            }
            if (source.getParent() != ListAccessor.this.parent) {
                return false;
            }
            for (int i = 0; i < ListAccessor.this.list.size(); ++i) {
                if (ListAccessor.this.list.get(i) != source) continue;
                ListAccessor.this.parent.disown((AbstractNode)source);
                ListAccessor.this.fixEscaped();
                ListAccessor.this.list.remove(i);
                return true;
            }
            return false;
        }

        @Override
        public StrictListAccessor<T, P> asStrictAccessor() {
            return ListAccessor.this.strict;
        }

        @Override
        public Iterator<Node> iterator() {
            final Iterator it = ListAccessor.this.list.iterator();
            ListAccessor.this.escaped = true;
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Node next() {
                    return (Node)it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Iterator is read only");
                }
            };
        }
    };
    private StrictListAccessor<T, P> strict = new StrictListAccessor<T, P>(){

        @Override
        public P up() {
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public Node owner() {
            return ListAccessor.this.parent;
        }

        @Override
        public void clear() {
            if (ListAccessor.this.escaped) {
                ListAccessor.this.list = new ArrayList();
                ListAccessor.this.escaped = false;
            } else {
                ListAccessor.this.list.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return ListAccessor.this.list.isEmpty();
        }

        @Override
        public int size() {
            return ListAccessor.this.list.size();
        }

        @Override
        public T first() {
            Node r = ListAccessor.this.raw.first();
            if (!ListAccessor.this.tClass.isInstance(r)) {
                return null;
            }
            return (Node)ListAccessor.this.tClass.cast(r);
        }

        @Override
        public T last() {
            Node r = ListAccessor.this.raw.last();
            if (!ListAccessor.this.tClass.isInstance(r)) {
                return null;
            }
            return (Node)ListAccessor.this.tClass.cast(r);
        }

        @Override
        public boolean contains(Node source) {
            return ListAccessor.this.raw.contains(source);
        }

        @Override
        public P migrateAllFrom(StrictListAccessor<? extends T, ?> otherList) {
            while (!otherList.isEmpty()) {
                AbstractNode n = (AbstractNode)otherList.first();
                otherList.remove(n);
                ListAccessor.this.raw.addToEnd(n);
            }
            return ListAccessor.this.returnAsParent;
        }

        @Override
        public P addToStart(T ... node) {
            return ListAccessor.this.raw.addToStart((Node[])node);
        }

        @Override
        public P addToEnd(T ... node) {
            return ListAccessor.this.raw.addToEnd((Node[])node);
        }

        @Override
        public P addBefore(Node ref, T ... node) {
            return ListAccessor.this.raw.addBefore(ref, (Node[])node);
        }

        @Override
        public P addAfter(Node ref, T ... node) {
            return ListAccessor.this.raw.addAfter(ref, (Node[])node);
        }

        @Override
        public void replace(Node source, T replacement) throws NoSuchElementException {
            if (source == null) {
                throw new NullPointerException();
            }
            if (source.getParent() != ListAccessor.this.parent) {
                throw new NoSuchElementException(ListAccessor.this.listName + " is not the parent of: " + source);
            }
            if (!ListAccessor.this.raw.replace(source, (Node)replacement)) {
                throw new NoSuchElementException(ListAccessor.this.listName + " does not contain: " + source);
            }
        }

        @Override
        public void remove(Node source) throws NoSuchElementException {
            if (source == null) {
                throw new NullPointerException();
            }
            if (source.getParent() != ListAccessor.this.parent) {
                throw new NoSuchElementException(ListAccessor.this.listName + " is not the parent of: " + source);
            }
            if (!ListAccessor.this.raw.remove(source)) {
                throw new NoSuchElementException(ListAccessor.this.listName + " does not contain: " + source);
            }
        }

        @Override
        public RawListAccessor<T, P> asRawAccessor() {
            return ListAccessor.this.raw;
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator it = ListAccessor.this.list.iterator();
            ListAccessor.this.escaped = true;
            return new Iterator<T>(){
                T next = null;
                {
                    this.advance();
                }

                private void advance() {
                    while (it.hasNext()) {
                        Node potential = (Node)it.next();
                        if (!ListAccessor.this.tClass.isInstance(potential)) continue;
                        this.next = (Node)ListAccessor.this.tClass.cast(potential);
                        return;
                    }
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public T next() {
                    if (this.next == null) {
                        throw new NoSuchElementException("No more elements");
                    }
                    Object node = this.next;
                    this.advance();
                    return node;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Iterator is read only");
                }
            };
        }
    };

    private ListAccessor(AbstractNode parent, Class<T> tClass, String listName, P returnAsParent) {
        this.list = new ArrayList<AbstractNode>();
        this.parent = parent;
        this.tClass = tClass;
        this.listName = listName;
        this.returnAsParent = returnAsParent;
    }

    private void fixEscaped() {
        if (this.escaped) {
            this.list = new ArrayList<AbstractNode>(this.list);
            this.escaped = false;
        }
    }

    public static <T extends Node, P extends Node> StrictListAccessor<T, P> emptyStrict(final String listName, final P returnAsParent) {
        return new StrictListAccessor<T, P>(){

            @Override
            public P addAfter(Node ref, T ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addBefore(Node ref, T ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addToEnd(T ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addToStart(T ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RawListAccessor<T, P> asRawAccessor() {
                return ListAccessor.emptyRaw(listName, returnAsParent);
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean contains(Node source) {
                return false;
            }

            @Override
            public T first() {
                return null;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public T last() {
                return null;
            }

            @Override
            public P migrateAllFrom(StrictListAccessor<? extends T, ?> otherList) {
                if (otherList != null && otherList.getClass() != this.getClass()) {
                    throw new UnsupportedOperationException();
                }
                return returnAsParent;
            }

            @Override
            public Node owner() {
                return returnAsParent;
            }

            @Override
            public void remove(Node source) throws NoSuchElementException {
                throw new NoSuchElementException();
            }

            @Override
            public void replace(Node source, T replacement) throws NoSuchElementException {
                throw new NoSuchElementException(listName + " does not contain: " + source);
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public P up() {
                return returnAsParent;
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyList().iterator();
            }
        };
    }

    public static <T extends Node, P extends Node> RawListAccessor<T, P> emptyRaw(final String listName, final P returnAsParent) {
        return new RawListAccessor<T, P>(){

            @Override
            public P addAfter(Node ref, Node ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addBefore(Node ref, Node ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addToEnd(Node ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public P addToStart(Node ... node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public StrictListAccessor<T, P> asStrictAccessor() {
                return ListAccessor.emptyStrict(listName, returnAsParent);
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean contains(Node source) {
                return false;
            }

            @Override
            public Node first() {
                return null;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public Node last() {
                return null;
            }

            @Override
            public P migrateAllFrom(RawListAccessor<?, ?> otherList) {
                if (otherList != null && otherList.getClass() != this.getClass()) {
                    throw new UnsupportedOperationException();
                }
                return returnAsParent;
            }

            @Override
            public Node owner() {
                return returnAsParent;
            }

            @Override
            public boolean remove(Node source) {
                return false;
            }

            @Override
            public boolean replace(Node source, Node replacement) throws NoSuchElementException {
                return false;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public P up() {
                return returnAsParent;
            }

            @Override
            public Iterator<Node> iterator() {
                return Collections.emptyList().iterator();
            }
        };
    }

    static <T extends Node, P extends AbstractNode> ListAccessor<T, P> of(P parent, Class<T> tClass, String listName) {
        return new ListAccessor<T, P>(parent, tClass, listName, parent);
    }

    <Q extends Node> ListAccessor<T, Q> wrap(final Q returnThisAsParent) {
        final ListAccessor original = this;
        return new ListAccessor<T, Q>(this.parent, this.tClass, this.listName, returnThisAsParent){
            final RawListAccessor<T, Q> raw;
            final StrictListAccessor<T, Q> strict;
            {
                super(x0, x1, x2, x3, null);
                this.raw = new RawListAccessor<T, Q>(){
                    final RawListAccessor<T, P> orig;
                    {
                        this.orig = original.asRaw();
                    }

                    @Override
                    public Iterator<Node> iterator() {
                        return this.orig.iterator();
                    }

                    @Override
                    public Q up() {
                        return returnThisAsParent;
                    }

                    @Override
                    public Node owner() {
                        return this.orig.owner();
                    }

                    @Override
                    public void clear() {
                        this.orig.clear();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.orig.isEmpty();
                    }

                    @Override
                    public int size() {
                        return this.orig.size();
                    }

                    @Override
                    public Node first() {
                        return this.orig.first();
                    }

                    @Override
                    public Node last() {
                        return this.orig.last();
                    }

                    @Override
                    public boolean contains(Node source) {
                        return this.orig.contains(source);
                    }

                    @Override
                    public Q migrateAllFrom(RawListAccessor<?, ?> otherList) {
                        this.orig.migrateAllFrom(otherList);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addToStart(Node ... node) {
                        this.orig.addToStart(node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addToEnd(Node ... node) {
                        this.orig.addToEnd(node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addBefore(Node ref, Node ... node) {
                        this.orig.addBefore(ref, node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addAfter(Node ref, Node ... node) {
                        this.orig.addAfter(ref, node);
                        return returnThisAsParent;
                    }

                    @Override
                    public boolean replace(Node source, Node replacement) {
                        return this.orig.replace(source, replacement);
                    }

                    @Override
                    public boolean remove(Node source) {
                        return this.orig.remove(source);
                    }

                    @Override
                    public StrictListAccessor<T, Q> asStrictAccessor() {
                        return this.asStrict();
                    }
                };
                this.strict = new StrictListAccessor<T, Q>(){
                    final StrictListAccessor<T, P> orig;
                    {
                        this.orig = original.asStrict();
                    }

                    @Override
                    public Iterator<T> iterator() {
                        return this.orig.iterator();
                    }

                    @Override
                    public Q up() {
                        return returnThisAsParent;
                    }

                    @Override
                    public Node owner() {
                        return this.orig.owner();
                    }

                    @Override
                    public void clear() {
                        this.orig.clear();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.orig.isEmpty();
                    }

                    @Override
                    public int size() {
                        return this.orig.size();
                    }

                    @Override
                    public T first() {
                        return this.orig.first();
                    }

                    @Override
                    public T last() {
                        return this.orig.last();
                    }

                    @Override
                    public boolean contains(Node source) {
                        return this.orig.contains(source);
                    }

                    @Override
                    public Q migrateAllFrom(StrictListAccessor<? extends T, ?> otherList) {
                        this.orig.migrateAllFrom(otherList);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addToStart(T ... node) {
                        this.orig.addToStart((Node[])node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addToEnd(T ... node) {
                        this.orig.addToEnd((Node[])node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addBefore(Node ref, T ... node) {
                        this.orig.addBefore(ref, (Node[])node);
                        return returnThisAsParent;
                    }

                    @Override
                    public Q addAfter(Node ref, T ... node) {
                        this.orig.addAfter(ref, (Node[])node);
                        return returnThisAsParent;
                    }

                    @Override
                    public void replace(Node source, T replacement) throws NoSuchElementException {
                        this.orig.replace(source, replacement);
                    }

                    @Override
                    public void remove(Node source) throws NoSuchElementException {
                        this.orig.remove(source);
                    }

                    @Override
                    public RawListAccessor<T, Q> asRawAccessor() {
                        return this.asRaw();
                    }
                };
            }

            @Override
            <Q2 extends Node> ListAccessor<T, Q2> wrap(Q2 returnThisAsParent2) {
                return original.wrap(returnThisAsParent2);
            }

            @Override
            StrictListAccessor<T, Q> asStrict() {
                return this.strict;
            }

            @Override
            RawListAccessor<T, Q> asRaw() {
                return this.raw;
            }

            @Override
            Iterable<AbstractNode> asIterable() {
                return original.asIterable();
            }

            @Override
            List<AbstractNode> backingList() {
                return original.backingList();
            }
        };
    }

    StrictListAccessor<T, P> asStrict() {
        return this.strict;
    }

    RawListAccessor<T, P> asRaw() {
        return this.raw;
    }

    Iterable<AbstractNode> asIterable() {
        this.escaped = true;
        return this.list;
    }

    List<AbstractNode> backingList() {
        return this.list;
    }

    /* synthetic */ ListAccessor(AbstractNode x0, Class x1, String x2, Node x3, 1 x4) {
        this(x0, x1, x2, x3);
    }
}

