/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Modifier;

@BugPattern(name="PrivateConstructorForUtilityClass", summary="Utility classes (only static members) are not designed to be instantiated and should be made noninstantiable with a default constructor.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class PrivateConstructorForUtilityClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS) || classTree.getExtendsClause() != null || !classTree.getImplementsClause().isEmpty() || PrivateConstructorForUtilityClass.isInPrivateScope(state)) {
            return Description.NO_MATCH;
        }
        FluentIterable nonSyntheticMembers = FluentIterable.from(classTree.getMembers()).filter(Predicates.not((Predicate)new Predicate<Tree>(){

            public boolean apply(Tree tree) {
                return tree.getKind().equals((Object)Tree.Kind.METHOD) && ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)tree));
            }
        }));
        if (nonSyntheticMembers.isEmpty()) {
            return Description.NO_MATCH;
        }
        boolean isUtilityClass = nonSyntheticMembers.allMatch((Predicate)new Predicate<Tree>(){

            public boolean apply(Tree tree) {
                switch (tree.getKind()) {
                    case CLASS: {
                        return ((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                    }
                    case METHOD: {
                        return ((MethodTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                    }
                    case VARIABLE: {
                        return ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                    }
                    case BLOCK: {
                        return ((BlockTree)tree).isStatic();
                    }
                    case ENUM: 
                    case ANNOTATION_TYPE: 
                    case INTERFACE: {
                        return true;
                    }
                }
                throw new AssertionError((Object)("unknown member type:" + (Object)((Object)tree.getKind())));
            }
        });
        if (!isUtilityClass) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(classTree, SuggestedFixes.addMembers((ClassTree)classTree, (VisitorState)state, (String)("private " + classTree.getSimpleName() + "() {}"), (String[])new String[0]));
    }

    private static boolean isInPrivateScope(VisitorState state) {
        TreePath treePath = state.getPath();
        do {
            ClassTree currentClassTree;
            Tree currentLeaf;
            if (!ClassTree.class.isInstance(currentLeaf = treePath.getLeaf()) || !(currentClassTree = (ClassTree)currentLeaf).getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        } while ((treePath = treePath.getParentPath()) != null);
        return false;
    }
}

