/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.google.common.primitives.Ints;
import java.io.IOException;

class GPFlags {
    private static final int BIT_ENCRYPTION = 1;
    private static final int BIT_METHOD = 6;
    private static final int BIT_DEFERRED_CRC = 8;
    private static final int BIT_ENHANCED_DEFLATING = 16;
    private static final int BIT_PATCHED_DATA = 32;
    private static final int BIT_STRONG_ENCRYPTION = 8256;
    private static final int BIT_UNUSED = 53120;
    private final long mValue;
    private boolean mDeferredCrc;

    private GPFlags(long value) {
        this.mValue = value;
        this.mDeferredCrc = (value & 8L) != 0L;
    }

    public long getValue() {
        return this.mValue;
    }

    public boolean isDeferredCrc() {
        return this.mDeferredCrc;
    }

    static GPFlags makeDefault() {
        return new GPFlags(0L);
    }

    static GPFlags from(long bits) throws IOException {
        if ((bits & 1L) != 0L) {
            throw new IOException("Zip files with encrypted of entries not supported.");
        }
        if ((bits & 0x10L) != 0L) {
            throw new IOException("Enhanced deflating not supported.");
        }
        if ((bits & 0x20L) != 0L) {
            throw new IOException("Compressed patched data not supported.");
        }
        if ((bits & 0x2040L) != 0L) {
            throw new IOException("Strong encryption not supported.");
        }
        if ((bits & 0xCF80L) != 0L) {
            throw new IOException("Unused bits set in directory entry. Weird. I don't know what's going on.");
        }
        int methodBit = Ints.checkedCast((long)(bits & 6L));
        if (methodBit != 0) {
            throw new IOException("Unsupported method bit: " + methodBit + ".");
        }
        if ((bits & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("Unsupported bits after 32.");
        }
        return new GPFlags(bits);
    }
}

