/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Abort;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;

public class JDK9Wrappers {

    public static final class JmodFile {
        public static final String JMOD_FILE_CLASSNAME = "jdk.internal.jmod.JmodFile";
        private static Class<?> jmodFileClass = null;
        private static Method checkMagicMethod = null;

        public static void checkMagic(Path file) throws IOException {
            try {
                JmodFile.init();
                checkMagicMethod.invoke(null, file);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)IOException.class.cast(ex.getCause());
                }
                throw new Abort(ex);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                throw new Abort(ex);
            }
        }

        private static void init() {
            if (jmodFileClass == null) {
                try {
                    jmodFileClass = Class.forName(JMOD_FILE_CLASSNAME, false, null);
                    checkMagicMethod = jmodFileClass.getDeclaredMethod("checkMagic", Path.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static final class VMHelper {
        public static final String CLASSNAME = "jdk.internal.misc.VM";
        private static Class<?> vmClass = null;
        private static Method getRuntimeArgumentsMethod = null;

        public static String[] getRuntimeArguments() {
            try {
                VMHelper.init();
                Object result = getRuntimeArgumentsMethod.invoke(null, new Object[0]);
                return (String[])result;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        private static void init() {
            if (vmClass == null) {
                try {
                    vmClass = Class.forName(CLASSNAME, false, null);
                    getRuntimeArgumentsMethod = vmClass.getDeclaredMethod("getRuntimeArguments", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static final class Layer {
        private final Object theRealLayer;
        private static Class<?> layerClass = null;
        private static Method bootMethod;
        private static Method defineModulesWithOneLoaderMethod;
        private static Method configurationMethod;

        private Layer(Object layer) {
            this.theRealLayer = layer;
        }

        public static Layer boot() {
            try {
                Layer.init();
                Object result = bootMethod.invoke(null, new Object[0]);
                Layer layer = new Layer(result);
                return layer;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        public Configuration configuration() {
            try {
                Object result = configurationMethod.invoke(this.theRealLayer, new Object[0]);
                Configuration configuration = new Configuration(result);
                return configuration;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        public Layer defineModulesWithOneLoader(Configuration configuration, ClassLoader parentClassLoader) {
            try {
                Object result = defineModulesWithOneLoaderMethod.invoke(this.theRealLayer, configuration.theRealConfiguration, parentClassLoader);
                Layer layer = new Layer(result);
                return layer;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        private static void init() {
            if (layerClass == null) {
                try {
                    layerClass = Class.forName("java.lang.ModuleLayer", false, null);
                    bootMethod = layerClass.getDeclaredMethod("boot", new Class[0]);
                    defineModulesWithOneLoaderMethod = layerClass.getDeclaredMethod("defineModulesWithOneLoader", Configuration.getConfigurationClass(), ClassLoader.class);
                    configurationMethod = layerClass.getDeclaredMethod("configuration", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static final class Configuration {
        private final Object theRealConfiguration;
        private static Class<?> configurationClass = null;
        private static Method resolveAndBindMethod;

        private Configuration(Object configuration) {
            this.theRealConfiguration = configuration;
            Configuration.init();
        }

        public Configuration resolveAndBind(ModuleFinder beforeFinder, ModuleFinder afterFinder, Collection<String> roots) {
            try {
                Object result = resolveAndBindMethod.invoke(this.theRealConfiguration, beforeFinder.theRealModuleFinder, afterFinder.theRealModuleFinder, roots);
                Configuration configuration = new Configuration(result);
                return configuration;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        static final Class<?> getConfigurationClass() {
            Configuration.init();
            return configurationClass;
        }

        private static void init() {
            if (configurationClass == null) {
                try {
                    configurationClass = Class.forName("java.lang.module.Configuration", false, null);
                    Class<?> moduleFinderInterface = ModuleFinder.getModuleFinderClass();
                    resolveAndBindMethod = configurationClass.getDeclaredMethod("resolveAndBind", moduleFinderInterface, moduleFinderInterface, Collection.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static class Module {
        private final Object theRealModule;
        private static Method addExportsMethod = null;
        private static Method addUsesMethod = null;
        private static Method getModuleMethod;
        private static Method getUnnamedModuleMethod;

        private Module(Object module) {
            this.theRealModule = module;
            Module.init();
        }

        public static Module getModule(Class<?> clazz) {
            try {
                Module.init();
                Object result = getModuleMethod.invoke(clazz, new Object[0]);
                return new Module(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        public static Module getUnnamedModule(ClassLoader classLoader) {
            try {
                Module.init();
                Object result = getUnnamedModuleMethod.invoke((Object)classLoader, new Object[0]);
                return new Module(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        public Module addExports(String pn, Module other) {
            try {
                addExportsMethod.invoke(this.theRealModule, pn, other.theRealModule);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
            return this;
        }

        public Module addUses(Class<?> st) {
            try {
                addUsesMethod.invoke(this.theRealModule, st);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
            return this;
        }

        private static void init() {
            if (addExportsMethod == null) {
                try {
                    Class<?> moduleClass = Class.forName("java.lang.Module", false, null);
                    addUsesMethod = moduleClass.getDeclaredMethod("addUses", Class.class);
                    addExportsMethod = moduleClass.getDeclaredMethod("addExports", String.class, moduleClass);
                    getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
                    getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static class ModuleFinder {
        private final Object theRealModuleFinder;
        private static Class<?> moduleFinderClass = null;
        private static Method ofMethod;

        private ModuleFinder(Object moduleFinder) {
            this.theRealModuleFinder = moduleFinder;
            ModuleFinder.init();
        }

        public static ModuleFinder of(Path ... dirs) {
            try {
                ModuleFinder.init();
                Object result = ofMethod.invoke(null, new Object[]{dirs});
                ModuleFinder mFinder = new ModuleFinder(result);
                return mFinder;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        static final Class<?> getModuleFinderClass() {
            ModuleFinder.init();
            return moduleFinderClass;
        }

        private static void init() {
            if (moduleFinderClass == null) {
                try {
                    moduleFinderClass = Class.forName("java.lang.module.ModuleFinder", false, null);
                    ofMethod = moduleFinderClass.getDeclaredMethod("of", Path[].class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }

    public static class ModuleDescriptor {

        public static class Version {
            public static final String CLASSNAME = "java.lang.module.ModuleDescriptor$Version";
            private final Object theRealVersion;
            private static Class<?> versionClass = null;
            private static Method parseMethod = null;

            private Version(Object version) {
                this.theRealVersion = version;
            }

            public static Version parse(String v) {
                try {
                    Version.init();
                    Object result = parseMethod.invoke(null, v);
                    Version version = new Version(result);
                    return version;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)ex.getCause();
                    }
                    throw new Abort(ex);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }

            public String toString() {
                return this.theRealVersion.toString();
            }

            private static void init() {
                if (versionClass == null) {
                    try {
                        versionClass = Class.forName(CLASSNAME, false, null);
                        parseMethod = versionClass.getDeclaredMethod("parse", String.class);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                        throw new Abort(ex);
                    }
                }
            }
        }
    }

    public static final class ServiceLoaderHelper {
        private static Method loadMethod = null;

        public static <S> ServiceLoader<S> load(Layer layer, Class<S> service) {
            try {
                ServiceLoaderHelper.init();
                Object result = loadMethod.invoke(null, layer.theRealLayer, service);
                return (ServiceLoader)result;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                throw new Abort(ex);
            }
        }

        private static void init() {
            if (loadMethod == null) {
                try {
                    Class layerClass = Layer.layerClass;
                    loadMethod = ServiceLoader.class.getDeclaredMethod("load", layerClass, Class.class);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    throw new Abort(ex);
                }
            }
        }
    }
}

