/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DependencyFile {
    private final File mDependencyFile;
    private final List<File> mSourceFolders;
    private boolean mIsParsed = false;
    private List<File> mOutputFiles;
    private List<File> mInputFiles;
    private List<File> mSdkInputFiles;

    public DependencyFile(File dependencyFile, List<File> sourceFolders) {
        this.mDependencyFile = dependencyFile;
        this.mSourceFolders = sourceFolders;
    }

    public File getFile() {
        return this.mDependencyFile;
    }

    public List<File> getInputFiles() {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        return this.mInputFiles;
    }

    public List<File> getSdkInputFiles() {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        return this.mSdkInputFiles;
    }

    public List<File> getOutputFiles() {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        return this.mOutputFiles;
    }

    public File getFirstOutput() {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        if (!this.mOutputFiles.isEmpty()) {
            return this.mOutputFiles.get(0);
        }
        return null;
    }

    public boolean hasInput(File file) {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        return this.mInputFiles.contains(file);
    }

    public boolean hasOutput(File file) {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        return this.mOutputFiles.contains(file);
    }

    public void parse() throws IOException {
        if (!this.mDependencyFile.isFile()) {
            this.mInputFiles = Collections.emptyList();
            this.mOutputFiles = Collections.emptyList();
            this.mIsParsed = true;
            return;
        }
        List lines = Files.readLines((File)this.mDependencyFile, (Charset)Charsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if ((line = line.trim()).endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
            }
            sb.append(line);
        }
        String[] files = sb.toString().split(":");
        String[] outputs = files[0].trim().split(" ");
        this.mOutputFiles = this.getList(outputs);
        String[] inputs = files[1].trim().split(" ");
        if (inputs.length == 0) {
            this.mInputFiles = Collections.emptyList();
            this.mSdkInputFiles = Collections.emptyList();
        }
        this.mInputFiles = Lists.newArrayListWithExpectedSize((int)inputs.length);
        this.mSdkInputFiles = Lists.newArrayListWithExpectedSize((int)inputs.length);
        for (String path : inputs) {
            File f = new File(path);
            if (DependencyFile.checkParentFile(f, this.mSourceFolders)) {
                this.mInputFiles.add(f);
                continue;
            }
            this.mSdkInputFiles.add(f);
        }
        this.mIsParsed = true;
    }

    @Deprecated
    public boolean needCompilation() {
        if (!this.mIsParsed) {
            throw new IllegalStateException("Parsing was not done");
        }
        long inputTime = 0L;
        for (File file : this.mInputFiles) {
            long time = file.lastModified();
            if (time <= inputTime) continue;
            inputTime = time;
        }
        long outputTime = Long.MAX_VALUE;
        for (File file : this.mOutputFiles) {
            long time = file.lastModified();
            if (time >= outputTime) continue;
            outputTime = time;
        }
        return outputTime < inputTime;
    }

    private List<File> getList(String[] paths) {
        if (paths.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)paths.length);
        for (String path : paths) {
            list.add(new File(path));
        }
        return list;
    }

    public String toString() {
        return "DependencyFile{mDependencyFile=" + this.mDependencyFile + ", mIsParsed=" + this.mIsParsed + ", mOutputFiles=" + this.mOutputFiles + ", mInputFiles=" + this.mInputFiles + '}';
    }

    private static boolean checkParentFile(File child, List<File> parents) {
        for (File parent : parents) {
            if (!parent.equals(child)) continue;
            return true;
        }
        File childParent = child.getParentFile();
        if (childParent == null) {
            return false;
        }
        return DependencyFile.checkParentFile(childParent, parents);
    }
}

