/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.StaticOrder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

class AndroidImportOrganizer
implements ImportOrganizer {
    private static final String ANDROID = "android";
    private static final String COM_ANDROID = "com.android";
    private static final String JAVA = "java";
    private static final String JAVAX = "javax";
    private static final ImmutableSet<String> SPECIAL_ROOTS = ImmutableSet.of((Object)"android", (Object)"com.android", (Object)"java", (Object)"javax");
    private final StaticOrder order;

    AndroidImportOrganizer(StaticOrder order) {
        this.order = order;
    }

    @Override
    public ImportOrganizer.OrganizedImports organizeImports(List<ImportOrganizer.Import> imports) {
        ImportOrganizer.OrganizedImports organized = new ImportOrganizer.OrganizedImports();
        Map<Boolean, List<ImportOrganizer.Import>> partionedByStatic = imports.stream().collect(Collectors.partitioningBy(ImportOrganizer.Import::isStatic));
        for (Boolean key : this.order.groupOrder()) {
            this.organizePartition(organized, partionedByStatic.get(key));
        }
        return organized;
    }

    private void organizePartition(ImportOrganizer.OrganizedImports organized, List<ImportOrganizer.Import> imports) {
        Map groupedByRoot = imports.stream().collect(Collectors.groupingBy(AndroidImportOrganizer::rootPackage, TreeMap::new, ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(ImportOrganizer.Import::getType))));
        Set thirdParty = (Set)groupedByRoot.keySet().stream().filter(r -> !SPECIAL_ROOTS.contains(r)).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
        ImmutableList roots = ImmutableList.builder().add((Object)ANDROID).add((Object)COM_ANDROID).addAll((Iterable)thirdParty).add((Object)JAVA).add((Object)JAVAX).build();
        organized.addGroups(groupedByRoot, roots);
    }

    private static String rootPackage(ImportOrganizer.Import anImport) {
        String type = anImport.getType();
        if (type.startsWith("com.android.")) {
            return COM_ANDROID;
        }
        int index = type.indexOf(46);
        if (index == -1) {
            return "";
        }
        return type.substring(0, index);
    }
}

