/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.pubapi;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.StringUtils;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.pubapi.PubApiTypeParam;
import com.sun.tools.sjavac.pubapi.PubMethod;
import com.sun.tools.sjavac.pubapi.PubType;
import com.sun.tools.sjavac.pubapi.PubVar;
import com.sun.tools.sjavac.pubapi.TypeDesc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class PubApi
implements Serializable {
    private static final long serialVersionUID = 5926627347801986850L;
    public final Map<String, PubType> types = new HashMap<String, PubType>();
    public final Map<String, PubVar> variables = new HashMap<String, PubVar>();
    public final Map<String, PubMethod> methods = new HashMap<String, PubMethod>();
    private PubType lastInsertedType = null;
    private static final String MODIFIERS = Stream.of(Modifier.values()).map(Enum::name).map(StringUtils::toLowerCase).collect(Collectors.joining("|", "(", ")"));
    private static final Pattern MOD_PATTERN = Pattern.compile("(" + MODIFIERS + " )*");
    private static final Pattern METHOD_PATTERN = Pattern.compile("(?<ret>.+?) (?<name>\\S+)\\((?<params>.*)\\)( throws (?<throws>.*))?");
    private static final Pattern VAR_PATTERN = Pattern.compile("VAR (?<modifiers>(" + MODIFIERS + " )*)(?<type>.+?) (?<id>\\S+)( = (?<val>.*))?");
    private static final Pattern TYPE_PATTERN = Pattern.compile("TYPE (?<modifiers>(" + MODIFIERS + " )*)(?<fullyQualified>\\S+)");

    public PubApi() {
    }

    public PubApi(Collection<PubType> collection, Collection<PubVar> collection2, Collection<PubMethod> collection3) {
        collection.forEach(this::addPubType);
        collection2.forEach(this::addPubVar);
        collection3.forEach(this::addPubMethod);
    }

    public boolean isBackwardCompatibleWith(PubApi pubApi) {
        return this.equals(pubApi);
    }

    private static String typeLine(PubType pubType) {
        if (pubType.fqName.isEmpty()) {
            throw new RuntimeException("empty class name " + pubType);
        }
        return String.format("TYPE %s%s", PubApi.asString(pubType.modifiers), pubType.fqName);
    }

    private static String varLine(PubVar pubVar) {
        return String.format("VAR %s%s %s%s", PubApi.asString(pubVar.modifiers), TypeDesc.encodeAsString(pubVar.type), pubVar.identifier, pubVar.getConstValue().map(string -> " = " + string).orElse(""));
    }

    private static String methodLine(PubMethod pubMethod) {
        return String.format("METHOD %s%s%s %s(%s)%s", PubApi.asString(pubMethod.modifiers), pubMethod.typeParams.isEmpty() ? "" : "<" + pubMethod.typeParams.stream().map(PubApiTypeParam::asString).collect(Collectors.joining(",")) + "> ", TypeDesc.encodeAsString(pubMethod.returnType), pubMethod.identifier, PubApi.commaSeparated(pubMethod.paramTypes), pubMethod.throwDecls.isEmpty() ? "" : " throws " + PubApi.commaSeparated(pubMethod.throwDecls));
    }

    public List<String> asListOfStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.types.values().stream().sorted(Comparator.comparing(PubApi::typeLine)).forEach(pubType -> {
            arrayList.add(PubApi.typeLine(pubType));
            for (String string : pubType.pubApi.asListOfStrings()) {
                arrayList.add("  " + string);
            }
        });
        this.variables.values().stream().map(PubApi::varLine).sorted().forEach(arrayList::add);
        this.methods.values().stream().map(PubApi::methodLine).sorted().forEach(arrayList::add);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PubApi pubApi = (PubApi)object;
        return this.types.equals(pubApi.types) && this.variables.equals(pubApi.variables) && this.methods.equals(pubApi.methods);
    }

    public int hashCode() {
        return this.types.keySet().hashCode() ^ this.variables.keySet().hashCode() ^ this.methods.keySet().hashCode();
    }

    private static String commaSeparated(List<TypeDesc> list) {
        return list.stream().map(TypeDesc::encodeAsString).collect(Collectors.joining(","));
    }

    private static String asString(Set<Modifier> set) {
        return set.stream().map(modifier -> (Object)modifier + " ").sorted().collect(Collectors.joining());
    }

    public static PubApi mergeTypes(PubApi pubApi, PubApi pubApi2) {
        Assert.check(pubApi.methods.isEmpty(), "Can only merge types.");
        Assert.check(pubApi2.methods.isEmpty(), "Can only merge types.");
        Assert.check(pubApi.variables.isEmpty(), "Can only merge types.");
        Assert.check(pubApi2.variables.isEmpty(), "Can only merge types.");
        PubApi pubApi3 = new PubApi();
        pubApi3.types.putAll(pubApi.types);
        pubApi3.types.putAll(pubApi2.types);
        return pubApi3;
    }

    public void appendItem(String string) {
        try {
            if (string.startsWith("  ")) {
                this.lastInsertedType.pubApi.appendItem(string.substring(2));
                return;
            }
            if (string.startsWith("METHOD")) {
                Matcher matcher;
                Object object;
                Object object2;
                string = string.substring("METHOD ".length());
                HashSet<Modifier> hashSet = new HashSet<Modifier>();
                Matcher matcher2 = MOD_PATTERN.matcher(string);
                if (matcher2.find()) {
                    object2 = matcher2.group();
                    hashSet.addAll(this.parseModifiers((String)object2));
                    string = string.substring(((String)object2).length());
                }
                object2 = new ArrayList();
                if (string.startsWith("<")) {
                    int n = PubApi.findClosingTag(string, 0);
                    object = string.substring(1, n);
                    string = string.substring(n + 1);
                    object2.addAll(PubApi.parseTypeParams(this.splitOnTopLevelCommas((String)object)));
                }
                if (!(matcher = METHOD_PATTERN.matcher(string)).matches()) {
                    throw new AssertionError((Object)("Could not parse return type, identifier, parameter types or throws declaration of method: " + string));
                }
                object = this.splitOnTopLevelCommas(matcher.group("params"));
                String string2 = Optional.ofNullable(matcher.group("throws")).orElse("");
                List<String> list = this.splitOnTopLevelCommas(string2);
                PubMethod pubMethod = new PubMethod(hashSet, (List<PubApiTypeParam>)object2, TypeDesc.decodeString(matcher.group("ret")), matcher.group("name"), PubApi.parseTypeDescs((List<String>)object), PubApi.parseTypeDescs(list));
                this.addPubMethod(pubMethod);
                return;
            }
            Matcher matcher = VAR_PATTERN.matcher(string);
            if (matcher.matches()) {
                this.addPubVar(new PubVar(this.parseModifiers(matcher.group("modifiers")), TypeDesc.decodeString(matcher.group("type")), matcher.group("id"), matcher.group("val")));
                return;
            }
            Matcher matcher3 = TYPE_PATTERN.matcher(string);
            if (matcher3.matches()) {
                this.addPubType(new PubType(this.parseModifiers(matcher3.group("modifiers")), matcher3.group("fullyQualified"), new PubApi()));
                return;
            }
            throw new AssertionError((Object)"No matching line pattern.");
        }
        catch (Throwable throwable) {
            throw new AssertionError("Could not parse API line: " + string, throwable);
        }
    }

    public void addPubType(PubType pubType) {
        this.types.put(pubType.fqName, pubType);
        this.lastInsertedType = pubType;
    }

    public void addPubVar(PubVar pubVar) {
        this.variables.put(pubVar.identifier, pubVar);
    }

    public void addPubMethod(PubMethod pubMethod) {
        this.methods.put(pubMethod.asSignatureString(), pubMethod);
    }

    private static List<TypeDesc> parseTypeDescs(List<String> list) {
        return list.stream().map(TypeDesc::decodeString).collect(Collectors.toList());
    }

    private static List<PubApiTypeParam> parseTypeParams(List<String> list) {
        return list.stream().map(PubApi::parseTypeParam).collect(Collectors.toList());
    }

    private static PubApiTypeParam parseTypeParam(String string) {
        int n = string.indexOf(" extends ");
        if (n == -1) {
            return new PubApiTypeParam(string, Collections.emptyList());
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + " extends ".length());
        List<TypeDesc> list = PubApi.parseTypeDescs(PubApi.splitOnTopLevelChars(string3, '&'));
        return new PubApiTypeParam(string2, list);
    }

    public Set<Modifier> parseModifiers(String string2) {
        if (string2 == null) {
            return Collections.emptySet();
        }
        return Stream.of(string2.split(" ")).map(String::trim).map(StringUtils::toUpperCase).filter(string -> !string.isEmpty()).map(Modifier::valueOf).collect(Collectors.toSet());
    }

    private static int findClosingTag(String string, int n) {
        while (string.charAt(++n) != '>') {
            if (string.charAt(n) != '<') continue;
            n = PubApi.findClosingTag(string, n);
        }
        return n;
    }

    public List<String> splitOnTopLevelCommas(String string) {
        return PubApi.splitOnTopLevelChars(string, ',');
    }

    public static List<String> splitOnTopLevelChars(String string, char c) {
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 == c && n == 0) {
                arrayList.add(stringBuilder.toString().trim());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c2 == '<') {
                ++n;
            }
            if (c2 == '>') {
                --n;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString().trim());
        return arrayList;
    }

    public boolean isEmpty() {
        return this.types.isEmpty() && this.variables.isEmpty() && this.methods.isEmpty();
    }

    public List<String> diff(PubApi pubApi) {
        return this.diff("", pubApi);
    }

    private List<String> diff(String string, PubApi pubApi) {
        Serializable serializable;
        Serializable serializable2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : Util.union(this.types.keySet(), pubApi.types.keySet())) {
            serializable2 = this.types.get(string2);
            serializable = pubApi.types.get(string2);
            if (serializable == null) {
                arrayList.add("Type " + string + string2 + " was added");
                continue;
            }
            if (serializable2 == null) {
                arrayList.add("Type " + string + string2 + " was removed");
                continue;
            }
            if (!((PubType)serializable2).modifiers.equals(((PubType)serializable).modifiers)) {
                arrayList.add("Modifiers for type " + string + string2 + " changed from " + ((PubType)serializable).modifiers + " to " + ((PubType)serializable2).modifiers);
            }
            arrayList.addAll(((PubType)serializable2).pubApi.diff(((PubType)serializable).pubApi));
        }
        for (String string2 : Util.union(this.variables.keySet(), pubApi.variables.keySet())) {
            serializable2 = this.variables.get(string2);
            serializable = pubApi.variables.get(string2);
            if (serializable == null) {
                arrayList.add("Variable " + string + string2 + " was added");
                continue;
            }
            if (serializable2 == null) {
                arrayList.add("Variable " + string + string2 + " was removed");
                continue;
            }
            if (!((PubVar)serializable2).modifiers.equals(((PubVar)serializable).modifiers)) {
                arrayList.add("Modifiers for var " + string + string2 + " changed from " + ((PubVar)serializable).modifiers + " to " + ((PubVar)serializable2).modifiers);
            }
            if (!((PubVar)serializable2).type.equals(((PubVar)serializable).type)) {
                arrayList.add("Type of " + string + string2 + " changed from " + ((PubVar)serializable).type + " to " + ((PubVar)serializable2).type);
            }
            if (((PubVar)serializable2).getConstValue().equals(((PubVar)serializable).getConstValue())) continue;
            arrayList.add("Const value of " + string + string2 + " changed from " + ((PubVar)serializable).getConstValue().orElse("<none>") + " to " + ((PubVar)serializable2).getConstValue().orElse("<none>"));
        }
        for (String string2 : Util.union(this.methods.keySet(), pubApi.methods.keySet())) {
            serializable2 = this.methods.get(string2);
            serializable = pubApi.methods.get(string2);
            if (serializable == null) {
                arrayList.add("Method " + string + string2 + " was added");
                continue;
            }
            if (serializable2 == null) {
                arrayList.add("Method " + string + string2 + " was removed");
                continue;
            }
            if (!((PubMethod)serializable2).modifiers.equals(((PubMethod)serializable).modifiers)) {
                arrayList.add("Modifiers for method " + string + string2 + " changed from " + ((PubMethod)serializable).modifiers + " to " + ((PubMethod)serializable2).modifiers);
            }
            if (!((PubMethod)serializable2).typeParams.equals(((PubMethod)serializable).typeParams)) {
                arrayList.add("Type parameters for method " + string + string2 + " changed from " + ((PubMethod)serializable).typeParams + " to " + ((PubMethod)serializable2).typeParams);
            }
            if (((PubMethod)serializable2).throwDecls.equals(((PubMethod)serializable).throwDecls)) continue;
            arrayList.add("Throw decl for method " + string + string2 + " changed from " + ((PubMethod)serializable).throwDecls + " to  to " + ((PubMethod)serializable2).throwDecls);
        }
        return arrayList;
    }

    public String toString() {
        return String.format("%s[types: %s, variables: %s, methods: %s]", this.getClass().getSimpleName(), this.types.values(), this.variables.values(), this.methods.values());
    }
}

