/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEntry;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheEventContextUtil;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheKeyIteratorResult;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.maxsize.MaxSizeChecker;
import com.hazelcast.cache.impl.maxsize.impl.EntryCountCacheMaxSizeChecker;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordFactory;
import com.hazelcast.cache.impl.record.CacheRecordMap;
import com.hazelcast.cache.impl.record.SampleableCacheRecordMap;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.eviction.EvictionStrategy;
import com.hazelcast.internal.eviction.EvictionStrategyProvider;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;

public abstract class AbstractCacheRecordStore<R extends CacheRecord, CRM extends SampleableCacheRecordMap<Data, R>>
implements ICacheRecordStore,
EvictionListener<Data, R> {
    protected static final int DEFAULT_INITIAL_CAPACITY = 256;
    protected static final String SOURCE_NOT_AVAILABLE = "<NA>";
    protected final String name;
    protected final int partitionId;
    protected final int partitionCount;
    protected final NodeEngine nodeEngine;
    protected final AbstractCacheService cacheService;
    protected final CacheConfig cacheConfig;
    protected CRM records;
    protected CacheContext cacheContext;
    protected CacheStatisticsImpl statistics;
    protected CacheLoader cacheLoader;
    protected CacheWriter cacheWriter;
    protected boolean eventsEnabled = true;
    protected boolean eventsBatchingEnabled;
    protected ExpiryPolicy defaultExpiryPolicy;
    protected final EvictionConfig evictionConfig;
    protected final Map<CacheEventType, Set<CacheEventData>> batchEvent = new HashMap<CacheEventType, Set<CacheEventData>>();
    protected final MaxSizeChecker maxSizeChecker;
    protected final EvictionPolicyEvaluator<Data, R> evictionPolicyEvaluator;
    protected final EvictionChecker evictionChecker;
    protected final EvictionStrategy<Data, R, CRM> evictionStrategy;
    protected final boolean wanReplicationEnabled;
    protected boolean primary;

    public AbstractCacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, AbstractCacheService cacheService) {
        this.name = name;
        this.partitionId = partitionId;
        this.nodeEngine = nodeEngine;
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.cacheService = cacheService;
        this.cacheConfig = cacheService.getCacheConfig(name);
        this.cacheContext = cacheService.getOrCreateCacheContext(name);
        if (this.cacheConfig == null) {
            throw new CacheNotExistsException("Cache " + name + " is already destroyed or not created yet, on " + nodeEngine.getLocalMember());
        }
        this.wanReplicationEnabled = cacheService.isWanReplicationEnabled(name);
        this.evictionConfig = this.cacheConfig.getEvictionConfig();
        if (this.evictionConfig == null) {
            throw new IllegalStateException("Eviction config cannot be null");
        }
        if (this.cacheConfig.getCacheLoaderFactory() != null) {
            Factory cacheLoaderFactory = this.cacheConfig.getCacheLoaderFactory();
            if (cacheLoaderFactory instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)cacheLoaderFactory).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        }
        if (this.cacheConfig.getCacheWriterFactory() != null) {
            Factory cacheWriterFactory = this.cacheConfig.getCacheWriterFactory();
            if (cacheWriterFactory instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)cacheWriterFactory).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.cacheWriter = (CacheWriter)cacheWriterFactory.create();
        }
        if (this.cacheConfig.isStatisticsEnabled()) {
            this.statistics = cacheService.createCacheStatIfAbsent(name);
        }
        Factory expiryPolicyFactory = this.cacheConfig.getExpiryPolicyFactory();
        this.defaultExpiryPolicy = (ExpiryPolicy)expiryPolicyFactory.create();
        this.records = this.createRecordCacheMap();
        this.maxSizeChecker = this.createCacheMaxSizeChecker(this.evictionConfig.getSize(), this.evictionConfig.getMaximumSizePolicy());
        this.evictionPolicyEvaluator = this.createEvictionPolicyEvaluator(this.evictionConfig);
        this.evictionChecker = this.createEvictionChecker(this.evictionConfig);
        this.evictionStrategy = this.createEvictionStrategy(this.evictionConfig);
        if (this.cacheWriter instanceof Closeable) {
            cacheService.addCacheResource(name, (Closeable)this.cacheWriter);
        }
        if (this.cacheLoader instanceof Closeable) {
            cacheService.addCacheResource(name, (Closeable)this.cacheLoader);
        }
        if (this.defaultExpiryPolicy instanceof Closeable) {
            cacheService.addCacheResource(name, (Closeable)this.defaultExpiryPolicy);
        }
        this.init();
    }

    private boolean isPrimary() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        InternalPartition partition = partitionService.getPartition(this.partitionId, false);
        Address owner = partition.getOwnerOrNull();
        Address thisAddress = this.nodeEngine.getThisAddress();
        return owner != null && owner.equals(thisAddress);
    }

    @Override
    public void init() {
        this.primary = this.isPrimary();
        this.records.setEntryCounting(this.primary);
    }

    protected boolean isReadThrough() {
        return this.cacheConfig.isReadThrough();
    }

    protected boolean isWriteThrough() {
        return this.cacheConfig.isWriteThrough();
    }

    protected boolean isStatisticsEnabled() {
        return this.statistics != null;
    }

    protected abstract CRM createRecordCacheMap();

    protected abstract CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data var1, R var2, long var3, int var5);

    protected abstract R createRecord(Object var1, long var2, long var4);

    protected abstract Data valueToData(Object var1);

    protected abstract Object dataToValue(Data var1);

    protected abstract Object recordToValue(R var1);

    protected abstract Data recordToData(R var1);

    protected abstract Data toHeapData(Object var1);

    protected MaxSizeChecker createCacheMaxSizeChecker(int size, EvictionConfig.MaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-Size policy cannot be null");
        }
        if (maxSizePolicy == EvictionConfig.MaxSizePolicy.ENTRY_COUNT) {
            return new EntryCountCacheMaxSizeChecker(size, (CacheRecordMap)this.records, this.partitionCount);
        }
        return null;
    }

    protected EvictionPolicyEvaluator<Data, R> createEvictionPolicyEvaluator(EvictionConfig cacheEvictionConfig) {
        EvictionPolicy evictionPolicy = cacheEvictionConfig.getEvictionPolicy();
        if (evictionPolicy == null || evictionPolicy == EvictionPolicy.NONE || evictionPolicy == EvictionPolicy.RANDOM) {
            throw new IllegalArgumentException("Eviction policy cannot be `null`, `NONE` or `RANDOM`");
        }
        return EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(cacheEvictionConfig);
    }

    protected EvictionChecker createEvictionChecker(EvictionConfig cacheEvictionConfig) {
        return new MaxSizeEvictionChecker();
    }

    protected EvictionStrategy<Data, R, CRM> createEvictionStrategy(EvictionConfig cacheEvictionConfig) {
        return EvictionStrategyProvider.getEvictionStrategy(cacheEvictionConfig);
    }

    protected boolean isEvictionEnabled() {
        return this.evictionStrategy != null && this.evictionPolicyEvaluator != null;
    }

    protected boolean isEventsEnabled() {
        return this.eventsEnabled && (this.cacheContext.getCacheEntryListenerCount() > 0 || this.wanReplicationEnabled);
    }

    protected boolean isInvalidationEnabled() {
        return this.primary && this.cacheContext.getInvalidationListenerCount() > 0;
    }

    @Override
    public int evictIfRequired() {
        int evictedCount = 0;
        if (this.isEvictionEnabled()) {
            evictedCount = this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, this.evictionChecker, this);
            if (this.isStatisticsEnabled() && evictedCount > 0) {
                this.statistics.increaseCacheEvictions(evictedCount);
            }
        }
        return evictedCount;
    }

    protected Data toData(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof CacheRecord) {
            return this.recordToData((CacheRecord)obj);
        }
        return this.valueToData(obj);
    }

    protected Object toValue(Object obj) {
        if (obj instanceof Data) {
            return this.dataToValue((Data)obj);
        }
        if (obj instanceof CacheRecord) {
            return this.recordToValue((CacheRecord)obj);
        }
        return obj;
    }

    protected Object toStorageValue(Object obj) {
        if (obj instanceof Data) {
            if (this.cacheConfig.getInMemoryFormat() == InMemoryFormat.OBJECT) {
                return this.dataToValue((Data)obj);
            }
            return obj;
        }
        if (obj instanceof CacheRecord) {
            return this.recordToValue((CacheRecord)obj);
        }
        return obj;
    }

    public Data toEventData(Object obj) {
        return this.isEventsEnabled() ? this.toHeapData(obj) : null;
    }

    private long getAdjustedExpireTime(Duration duration, long now) {
        return duration.getAdjustedTime(now);
    }

    protected ExpiryPolicy getExpiryPolicy(ExpiryPolicy expiryPolicy) {
        return expiryPolicy != null ? expiryPolicy : this.defaultExpiryPolicy;
    }

    protected boolean processExpiredEntry(Data key, R record, long now) {
        return this.processExpiredEntry(key, record, now, SOURCE_NOT_AVAILABLE);
    }

    protected boolean processExpiredEntry(Data key, R record, long now, String source) {
        return this.processExpiredEntry(key, record, now, source, null);
    }

    protected boolean processExpiredEntry(Data key, R record, long now, String source, String origin) {
        boolean isExpired;
        boolean bl = isExpired = record != null && record.isExpiredAt(now);
        if (!isExpired) {
            return false;
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increaseCacheExpiries(1L);
        }
        R removedRecord = this.doRemoveRecord(key, source);
        Data keyEventData = this.toEventData(key);
        Data recordEventData = this.toEventData(removedRecord);
        this.onProcessExpiredEntry(key, removedRecord, removedRecord.getExpirationTime(), now, source, origin);
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheExpiredEvent(keyEventData, recordEventData, -1L, origin, -1));
        }
        return true;
    }

    protected R processExpiredEntry(Data key, R record, long expiryTime, long now, String source) {
        return this.processExpiredEntry(key, record, expiryTime, now, source, null);
    }

    protected R processExpiredEntry(Data key, R record, long expiryTime, long now, String source, String origin) {
        boolean isExpired = CacheRecordFactory.isExpiredAt(expiryTime, now);
        if (!isExpired) {
            return record;
        }
        if (this.isStatisticsEnabled()) {
            this.statistics.increaseCacheExpiries(1L);
        }
        R removedRecord = this.doRemoveRecord(key, source);
        Data keyEventData = this.toEventData(key);
        Data recordEventData = this.toEventData(removedRecord);
        this.onProcessExpiredEntry(key, removedRecord, expiryTime, now, source, origin);
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheExpiredEvent(keyEventData, recordEventData, -1L, origin, -1));
        }
        return null;
    }

    protected void onProcessExpiredEntry(Data key, R record, long expiryTime, long now, String source, String origin) {
    }

    public R accessRecord(Data key, R record, ExpiryPolicy expiryPolicy, long now) {
        this.onRecordAccess(key, record, this.getExpiryPolicy(expiryPolicy), now);
        return record;
    }

    @Override
    public void onEvict(Data key, R record) {
        this.invalidateEntry(key);
    }

    protected void invalidateEntry(Data key, String source) {
        if (this.isInvalidationEnabled()) {
            this.cacheService.sendInvalidationEvent(this.name, this.toHeapData(key), source);
        }
    }

    protected void invalidateEntry(Data key) {
        this.invalidateEntry(key, SOURCE_NOT_AVAILABLE);
    }

    protected void invalidateAllEntries() {
        this.invalidateAllEntries(SOURCE_NOT_AVAILABLE);
    }

    protected void invalidateAllEntries(String source) {
        this.invalidateEntry(null, source);
    }

    protected void updateGetAndPutStat(boolean isPutSucceed, boolean getValue, boolean oldValueNull, long start) {
        if (this.isStatisticsEnabled()) {
            if (isPutSucceed) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            if (getValue) {
                if (oldValueNull) {
                    this.statistics.increaseCacheMisses(1L);
                } else {
                    this.statistics.increaseCacheHits(1L);
                }
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
            }
        }
    }

    protected long updateAccessDuration(Data key, R record, ExpiryPolicy expiryPolicy, long now) {
        long expiryTime = -1L;
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForAccess();
            if (expiryDuration != null) {
                expiryTime = this.getAdjustedExpireTime(expiryDuration, now);
                record.setExpirationTime(expiryTime);
                if (this.isEventsEnabled()) {
                    CacheEventContext cacheEventContext = CacheEventContextUtil.createBaseEventContext(CacheEventType.EXPIRATION_TIME_UPDATED, this.toEventData(key), this.toEventData(record.getValue()), expiryTime, null, -1);
                    cacheEventContext.setAccessHit(record.getAccessHit());
                    this.publishEvent(cacheEventContext);
                }
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        return expiryTime;
    }

    protected long onRecordAccess(Data key, R record, ExpiryPolicy expiryPolicy, long now) {
        record.setAccessTime(now);
        record.incrementAccessHit();
        return this.updateAccessDuration(key, record, expiryPolicy, now);
    }

    protected void updateReplaceStat(boolean result, boolean isHit, long start) {
        if (this.isStatisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            if (isHit) {
                this.statistics.increaseCacheHits(1L);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
    }

    protected void publishEvent(CacheEventContext cacheEventContext) {
        if (this.isEventsEnabled()) {
            cacheEventContext.setCacheName(this.name);
            if (this.eventsBatchingEnabled) {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(this.name, cacheEventContext.getEventType(), cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), cacheEventContext.getDataOldValue(), cacheEventContext.isOldValueAvailable());
                Set<CacheEventData> cacheEventDataSet = this.batchEvent.remove((Object)cacheEventContext.getEventType());
                if (cacheEventDataSet == null) {
                    cacheEventDataSet = new HashSet<CacheEventData>();
                    this.batchEvent.put(cacheEventContext.getEventType(), cacheEventDataSet);
                }
                cacheEventDataSet.add(cacheEventData);
            } else {
                this.cacheService.publishEvent(cacheEventContext);
            }
        }
    }

    protected void publishBatchedEvents(String cacheName, CacheEventType cacheEventType, int orderKey) {
        Set<CacheEventData> cacheEventDatas;
        if (this.isEventsEnabled() && (cacheEventDatas = this.batchEvent.remove((Object)cacheEventType)) != null) {
            CacheEventSet ces = new CacheEventSet(cacheEventType, cacheEventDatas);
            this.cacheService.publishEvent(cacheName, ces, orderKey);
        }
    }

    protected boolean compare(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        if (v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    protected R createRecord(long expiryTime) {
        return this.createRecord(null, Clock.currentTimeMillis(), expiryTime);
    }

    protected R createRecord(Object value, long expiryTime) {
        return this.createRecord(value, Clock.currentTimeMillis(), expiryTime);
    }

    protected R createRecord(Data keyData, Object value, long expirationTime, int completionId) {
        R record = this.createRecord(value, expirationTime);
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheCreatedEvent(this.toEventData(keyData), this.toEventData(value), expirationTime, null, completionId));
        }
        return record;
    }

    protected void onCreateRecordError(Data key, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId, String origin, R record, Throwable error) {
    }

    protected R createRecord(Data key, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId, String origin) {
        R record = this.createRecord(value, now, expiryTime);
        try {
            this.doPutRecord(key, record);
        }
        catch (Throwable error) {
            this.onCreateRecordError(key, value, expiryTime, now, disableWriteThrough, completionId, origin, record, error);
            throw ExceptionUtil.rethrow(error);
        }
        try {
            if (!disableWriteThrough) {
                this.writeThroughCache(key, value);
            }
        }
        catch (Throwable error) {
            this.records.remove(key);
            this.onCreateRecordError(key, value, expiryTime, now, disableWriteThrough, completionId, origin, record, error);
            throw ExceptionUtil.rethrow(error);
        }
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheCreatedEvent(this.toEventData(key), this.toEventData(value), expiryTime, origin, completionId));
        }
        return record;
    }

    protected R createRecordWithExpiry(Data key, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId, String origin) {
        if (!CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            return this.createRecord(key, value, expiryTime, now, disableWriteThrough, completionId, origin);
        }
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), -1L, origin, completionId));
        }
        return null;
    }

    protected R createRecordWithExpiry(Data key, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId) {
        return this.createRecordWithExpiry(key, value, expiryTime, now, disableWriteThrough, completionId, null);
    }

    protected R createRecordWithExpiry(Data key, Object value, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId) {
        return this.createRecordWithExpiry(key, value, expiryPolicy, now, disableWriteThrough, completionId, null);
    }

    protected R createRecordWithExpiry(Data key, Object value, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId, String origin) {
        Duration expiryDuration;
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        try {
            expiryDuration = expiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = this.getAdjustedExpireTime(expiryDuration, now);
        return this.createRecordWithExpiry(key, value, expiryTime, now, disableWriteThrough, completionId, origin);
    }

    protected void onUpdateRecord(Data key, R record, Object value, Data oldDataValue) {
    }

    protected void onUpdateRecordError(Data key, R record, Object value, Data newDataValue, Data oldDataValue, Throwable error) {
    }

    protected void updateRecord(Data key, R record, Object value, long expiryTime, long now, boolean disableWriteThrough, int completionId, String source, String origin) {
        Data dataOldValue = null;
        Data dataValue = null;
        Object recordValue = value;
        try {
            if (expiryTime != -1L) {
                record.setExpirationTime(expiryTime);
            }
            if (CacheRecordFactory.isExpiredAt(expiryTime, now)) {
                if (!disableWriteThrough) {
                    this.writeThroughCache(key, value);
                }
            } else {
                switch (this.cacheConfig.getInMemoryFormat()) {
                    case BINARY: {
                        recordValue = this.toData(value);
                        dataValue = (Data)recordValue;
                        dataOldValue = this.toData(record);
                        break;
                    }
                    case OBJECT: {
                        if (value instanceof Data) {
                            recordValue = this.dataToValue((Data)value);
                            dataValue = (Data)value;
                        } else {
                            dataValue = this.valueToData(value);
                        }
                        dataOldValue = this.toData(record);
                        break;
                    }
                    case NATIVE: {
                        recordValue = this.toData(value);
                        dataValue = (Data)recordValue;
                        dataOldValue = this.toData(record);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                    }
                }
                if (!disableWriteThrough) {
                    this.writeThroughCache(key, value);
                }
                Data eventDataKey = this.toEventData(key);
                Data eventDataValue = this.toEventData(dataValue);
                Data eventDataOldValue = this.toEventData(dataOldValue);
                this.updateRecordValue(record, recordValue);
                this.onUpdateRecord(key, record, value, dataOldValue);
                this.invalidateEntry(key, source);
                if (this.isEventsEnabled()) {
                    this.publishEvent(CacheEventContextUtil.createCacheUpdatedEvent(eventDataKey, eventDataValue, eventDataOldValue, record.getExpirationTime(), record.getAccessTime(), record.getAccessHit(), origin, completionId));
                }
            }
        }
        catch (Throwable error) {
            this.onUpdateRecordError(key, record, value, dataValue, dataOldValue, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void updateRecordValue(R record, Object recordValue) {
        record.setValue((Object)recordValue);
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, long expiryTime, long now, boolean disableWriteThrough, int completionId, String source, String origin) {
        this.updateRecord(key, record, value, expiryTime, now, disableWriteThrough, completionId, source, origin);
        return this.processExpiredEntry(key, record, expiryTime, now, source) != null;
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, long expiryTime, long now, boolean disableWriteThrough, int completionId) {
        return this.updateRecordWithExpiry(key, value, record, expiryTime, now, disableWriteThrough, completionId, SOURCE_NOT_AVAILABLE);
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, long expiryTime, long now, boolean disableWriteThrough, int completionId, String source) {
        return this.updateRecordWithExpiry(key, value, record, expiryTime, now, disableWriteThrough, completionId, source, null);
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId) {
        return this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, disableWriteThrough, completionId, SOURCE_NOT_AVAILABLE);
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId, String source) {
        return this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, disableWriteThrough, completionId, source, null);
    }

    protected boolean updateRecordWithExpiry(Data key, Object value, R record, ExpiryPolicy expiryPolicy, long now, boolean disableWriteThrough, int completionId, String source, String origin) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long expiryTime = -1L;
        try {
            Duration expiryDuration = expiryPolicy.getExpiryForUpdate();
            if (expiryDuration != null) {
                expiryTime = this.getAdjustedExpireTime(expiryDuration, now);
            }
        }
        catch (Exception e) {
            EmptyStatement.ignore(e);
        }
        return this.updateRecordWithExpiry(key, value, record, expiryTime, now, disableWriteThrough, completionId, source, origin);
    }

    protected void onDeleteRecord(Data key, R record, Data dataValue, boolean deleted) {
    }

    protected void onDeleteRecordError(Data key, R record, Data dataValue, boolean deleted, Throwable error) {
    }

    protected boolean deleteRecord(Data key, int completionId) {
        return this.deleteRecord(key, completionId, SOURCE_NOT_AVAILABLE);
    }

    protected boolean deleteRecord(Data key, int completionId, String source) {
        return this.deleteRecord(key, completionId, source, null);
    }

    protected boolean deleteRecord(Data key, int completionId, String source, String origin) {
        R record = this.doRemoveRecord(key, source);
        Data dataValue = null;
        try {
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: 
                case OBJECT: 
                case NATIVE: {
                    dataValue = this.toData(record);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
                }
            }
            Data eventDataKey = this.toEventData(key);
            Data eventDataValue = this.toEventData(dataValue);
            this.onDeleteRecord(key, record, dataValue, record != null);
            if (this.isEventsEnabled()) {
                this.publishEvent(CacheEventContextUtil.createCacheRemovedEvent(eventDataKey, eventDataValue, -1L, origin, completionId));
            }
            return record != null;
        }
        catch (Throwable error) {
            this.onDeleteRecordError(key, record, dataValue, record != null, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    public R readThroughRecord(Data key, long now) {
        Duration expiryDuration;
        Object value = this.readThroughCache(key);
        if (value == null) {
            return null;
        }
        try {
            expiryDuration = this.defaultExpiryPolicy.getExpiryForCreation();
        }
        catch (Exception e) {
            expiryDuration = Duration.ETERNAL;
        }
        long expiryTime = this.getAdjustedExpireTime(expiryDuration, now);
        if (CacheRecordFactory.isExpiredAt(expiryTime, now)) {
            return null;
        }
        return this.createRecord(key, value, expiryTime, -1);
    }

    public Object readThroughCache(Data key) throws CacheLoaderException {
        if (this.isReadThrough() && this.cacheLoader != null) {
            try {
                Object o = this.dataToValue(key);
                return this.cacheLoader.load(o);
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during load", (Throwable)e);
                }
                throw (CacheLoaderException)e;
            }
        }
        return null;
    }

    public void writeThroughCache(Data key, Object value) throws CacheWriterException {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objKey = this.dataToValue(key);
                Object objValue = this.toValue(value);
                CacheEntry<Object, Object> entry = new CacheEntry<Object, Object>(objKey, objValue);
                this.cacheWriter.write(entry);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during write", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteCacheEntry(Data key) {
        if (this.isWriteThrough() && this.cacheWriter != null) {
            try {
                Object objKey = this.dataToValue(key);
                this.cacheWriter.delete(objKey);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during delete", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
        }
    }

    protected void deleteAllCacheEntry(Set<Data> keys) {
        if (this.isWriteThrough() && this.cacheWriter != null && keys != null && !keys.isEmpty()) {
            HashMap<Object, Data> keysToDelete = new HashMap<Object, Data>();
            for (Data key : keys) {
                Object localKeyObj = this.dataToValue(key);
                keysToDelete.put(localKeyObj, key);
            }
            Set keysObject = keysToDelete.keySet();
            try {
                this.cacheWriter.deleteAll(keysObject);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter during deleteAll", (Throwable)e);
                }
                throw (CacheWriterException)e;
            }
            finally {
                for (Object undeletedKey : keysObject) {
                    Data undeletedKeyData = (Data)keysToDelete.get(undeletedKey);
                    keys.remove(undeletedKeyData);
                }
            }
        }
    }

    protected Map<Data, Object> loadAllCacheEntry(Set<Data> keys) {
        if (this.cacheLoader != null) {
            Map loaded;
            HashMap<Object, Data> keysToLoad = new HashMap<Object, Data>();
            for (Data key : keys) {
                Object localKeyObj = this.dataToValue(key);
                keysToLoad.put(localKeyObj, key);
            }
            try {
                loaded = this.cacheLoader.loadAll(keysToLoad.keySet());
            }
            catch (Throwable e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader during loadAll", e);
                }
                throw (CacheLoaderException)e;
            }
            HashMap<Data, Object> result = new HashMap<Data, Object>();
            for (Map.Entry entry : keysToLoad.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObject = loaded.get(keyObj);
                Data keyData = (Data)entry.getValue();
                result.put(keyData, valueObject);
            }
            return result;
        }
        return null;
    }

    @Override
    public CacheRecord getRecord(Data key) {
        return (CacheRecord)this.records.get(key);
    }

    @Override
    public void putRecord(Data key, CacheRecord record) {
        this.evictIfRequired();
        this.doPutRecord(key, record);
    }

    public final R doPutRecord(Data key, R record) {
        return this.doPutRecord(key, record, SOURCE_NOT_AVAILABLE);
    }

    protected R doPutRecord(Data key, R record, String source) {
        CacheRecord oldRecord = (CacheRecord)this.records.put((Data)key, record);
        if (oldRecord != null) {
            this.invalidateEntry(key, source);
        }
        return (R)oldRecord;
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        return this.doRemoveRecord(key);
    }

    protected R doRemoveRecord(Data key) {
        return this.doRemoveRecord(key, SOURCE_NOT_AVAILABLE);
    }

    protected R doRemoveRecord(Data key, String source) {
        CacheRecord removedRecord = (CacheRecord)this.records.remove(key);
        if (removedRecord != null) {
            this.invalidateEntry(key, source);
        }
        return (R)removedRecord;
    }

    protected void onGet(Data key, ExpiryPolicy expiryPolicy, Object value, R record) {
    }

    protected void onGetError(Data key, ExpiryPolicy expiryPolicy, Object value, R record, Throwable error) {
    }

    @Override
    public Object get(Data key, ExpiryPolicy expiryPolicy) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        long now = Clock.currentTimeMillis();
        Object value = null;
        CacheRecord<Object> record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        try {
            if (this.recordNotExistOrExpired(record, isExpired)) {
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheMisses(1L);
                }
                if ((value = this.readThroughCache(key)) == null) {
                    if (this.isStatisticsEnabled()) {
                        this.statistics.addGetTimeNanos(System.nanoTime() - start);
                    }
                    return null;
                }
                record = this.createRecordWithExpiry(key, value, expiryPolicy, now, true, -1);
            } else {
                value = this.recordToValue(record);
                this.onRecordAccess(key, record, expiryPolicy, now);
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
            }
            this.onGet(key, expiryPolicy, value, record);
            return value;
        }
        catch (Throwable error) {
            this.onGetError(key, expiryPolicy, value, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean contains(Data key) {
        long now = Clock.currentTimeMillis();
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        return record != null && !isExpired;
    }

    protected void onPut(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean getValue, boolean disableWriteThrough, R record, Object oldValue, boolean isExpired, boolean isNewPut, boolean isSaveSucceed) {
    }

    protected void onPutError(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean getValue, boolean disableWriteThrough, R record, Object oldValue, boolean wouldBeNewPut, Throwable error) {
    }

    protected Object put(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean getValue, boolean disableWriteThrough, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean isOnNewPut = false;
        Object oldValue = null;
        CacheRecord<Object> record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now, source);
        try {
            boolean isSaveSucceed;
            if (record == null || isExpired) {
                isOnNewPut = true;
                record = this.createRecordWithExpiry(key, value, expiryPolicy, now, disableWriteThrough, completionId);
                isSaveSucceed = record != null;
            } else {
                if (getValue) {
                    oldValue = this.toValue(record);
                }
                isSaveSucceed = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, disableWriteThrough, completionId, source);
            }
            this.onPut(key, value, expiryPolicy, source, getValue, disableWriteThrough, record, oldValue, isExpired, isOnNewPut, isSaveSucceed);
            this.updateGetAndPutStat(isSaveSucceed, getValue, oldValue == null, start);
            if (getValue) {
                return oldValue;
            }
            return record;
        }
        catch (Throwable error) {
            this.onPutError(key, value, expiryPolicy, source, getValue, disableWriteThrough, record, oldValue, isOnNewPut, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected Object put(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean getValue, int completionId) {
        return this.put(key, value, expiryPolicy, source, getValue, false, completionId);
    }

    public R put(Data key, Object value, ExpiryPolicy expiryPolicy, String source, int completionId) {
        return (R)((CacheRecord)this.put(key, value, expiryPolicy, source, false, false, completionId));
    }

    @Override
    public Object getAndPut(Data key, Object value, ExpiryPolicy expiryPolicy, String source, int completionId) {
        return this.put(key, value, expiryPolicy, source, true, false, completionId);
    }

    protected void onPutIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean disableWriteThrough, R record, boolean isExpired, boolean isSaveSucceed) {
    }

    protected void onPutIfAbsentError(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean disableWriteThrough, R record, Throwable error) {
    }

    protected boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String source, boolean disableWriteThrough, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean saved = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now, source);
        try {
            if (record == null || isExpired) {
                saved = this.createRecordWithExpiry(key, value, expiryPolicy, now, disableWriteThrough, completionId) != null;
            } else if (this.isEventsEnabled()) {
                this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), completionId));
            }
            this.onPutIfAbsent(key, value, expiryPolicy, source, disableWriteThrough, record, isExpired, saved);
            if (saved && this.isStatisticsEnabled()) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            }
            return saved;
        }
        catch (Throwable error) {
            this.onPutIfAbsentError(key, value, expiryPolicy, source, disableWriteThrough, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean putIfAbsent(Data key, Object value, ExpiryPolicy expiryPolicy, String source, int completionId) {
        return this.putIfAbsent(key, value, expiryPolicy, source, false, completionId);
    }

    protected void onReplace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String source, boolean getValue, R record, boolean isExpired, boolean replaced) {
    }

    protected void onReplaceError(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String source, boolean getValue, R record, boolean isExpired, boolean replaced, Throwable error) {
    }

    @Override
    public boolean replace(Data key, Object value, ExpiryPolicy expiryPolicy, String source, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            if (this.recordNotExistOrExpired(record, isExpired)) {
                if (this.isEventsEnabled()) {
                    this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), completionId));
                }
            } else {
                replaced = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, false, completionId, source);
            }
            this.onReplace(key, null, value, expiryPolicy, source, false, record, isExpired, replaced);
            if (this.isStatisticsEnabled()) {
                if (replaced) {
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.addPutTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return replaced;
        }
        catch (Throwable error) {
            this.onReplaceError(key, null, value, expiryPolicy, source, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean replace(Data key, Object oldValue, Object newValue, ExpiryPolicy expiryPolicy, String source, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean isHit = false;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            if (record != null && !isExpired) {
                isHit = true;
                Object currentValue = this.toStorageValue(record);
                if (this.compare(currentValue, this.toStorageValue(oldValue))) {
                    replaced = this.updateRecordWithExpiry(key, newValue, record, expiryPolicy, now, false, completionId, source);
                } else {
                    this.onRecordAccess(key, record, expiryPolicy, now);
                }
            }
            if (!replaced && this.isEventsEnabled()) {
                this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), completionId));
            }
            this.onReplace(key, oldValue, newValue, expiryPolicy, source, false, record, isExpired, replaced);
            this.updateReplaceStat(replaced, isHit, start);
            return replaced;
        }
        catch (Throwable error) {
            this.onReplaceError(key, oldValue, newValue, expiryPolicy, source, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public Object getAndReplace(Data key, Object value, ExpiryPolicy expiryPolicy, String source, int completionId) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean replaced = false;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = record != null && record.isExpiredAt(now);
        try {
            Object obj = this.toValue(record);
            if (this.recordNotExistOrExpired(record, isExpired)) {
                obj = null;
                if (this.isEventsEnabled()) {
                    this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), completionId));
                }
            } else {
                replaced = this.updateRecordWithExpiry(key, value, record, expiryPolicy, now, false, completionId, source);
            }
            this.onReplace(key, null, value, expiryPolicy, source, false, record, isExpired, replaced);
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
                if (obj != null) {
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return obj;
        }
        catch (Throwable error) {
            this.onReplaceError(key, null, value, expiryPolicy, source, false, record, isExpired, replaced, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void onRemove(Data key, Object value, String source, boolean getValue, R record, boolean removed) {
    }

    protected void onRemoveError(Data key, Object value, String source, boolean getValue, R record, boolean removed, Throwable error) {
    }

    @Override
    public boolean remove(Data key, String source, int completionId) {
        return this.remove(key, source, completionId, null);
    }

    public boolean remove(Data key, String source, int completionId, String origin) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean removed = false;
        try {
            if (this.recordNotExistOrExpired(record, now)) {
                if (this.isEventsEnabled()) {
                    this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), -1L, origin, completionId));
                }
            } else {
                removed = this.deleteRecord(key, completionId, source, origin);
            }
            this.onRemove(key, null, source, false, record, removed);
            if (removed && this.isStatisticsEnabled()) {
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            }
            return removed;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, source, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean remove(Data key, Object value, String source, int completionId) {
        return this.remove(key, value, source, completionId, null);
    }

    public boolean remove(Data key, Object value, String source, int completionId, String origin) {
        long now = Clock.currentTimeMillis();
        long start = System.nanoTime();
        CacheRecord record = (CacheRecord)this.records.get(key);
        int hitCount = 0;
        boolean removed = false;
        try {
            if (this.recordNotExistOrExpired(record, now)) {
                if (this.isStatisticsEnabled()) {
                    this.statistics.increaseCacheMisses(1L);
                }
            } else {
                ++hitCount;
                if (this.compare(this.toStorageValue(record), this.toStorageValue(value))) {
                    this.deleteCacheEntry(key);
                    removed = this.deleteRecord(key, completionId, source, origin);
                } else {
                    long expiryTime = this.onRecordAccess(key, record, this.defaultExpiryPolicy, now);
                    this.processExpiredEntry(key, record, expiryTime, now, source, origin);
                }
            }
            if (!removed && this.isEventsEnabled()) {
                this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), -1L, origin, completionId));
            }
            this.onRemove(key, value, source, false, record, removed);
            this.updateRemoveStatistics(removed, hitCount, start);
            return removed;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, source, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    private void updateRemoveStatistics(boolean result, int hitCount, long start) {
        if (result && this.isStatisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            if (hitCount == 1) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
    }

    @Override
    public Object getAndRemove(Data key, String source, int completionId) {
        return this.getAndRemove(key, source, completionId, null);
    }

    public Object getAndRemove(Data key, String source, int completionId, String origin) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        this.deleteCacheEntry(key);
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean removed = false;
        try {
            Object obj;
            if (this.recordNotExistOrExpired(record, now)) {
                obj = null;
                if (this.isEventsEnabled()) {
                    this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(this.toEventData(key), -1L, origin, completionId));
                }
            } else {
                obj = this.toValue(record);
                removed = this.deleteRecord(key, completionId, source, origin);
            }
            this.onRemove(key, null, source, false, record, removed);
            if (this.isStatisticsEnabled()) {
                this.statistics.addGetTimeNanos(System.nanoTime() - start);
                if (obj != null) {
                    this.statistics.increaseCacheHits(1L);
                    this.statistics.increaseCacheRemovals(1L);
                    this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
                } else {
                    this.statistics.increaseCacheMisses(1L);
                }
            }
            return obj;
        }
        catch (Throwable error) {
            this.onRemoveError(key, null, source, false, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public MapEntries getAll(Set<Data> keySet, ExpiryPolicy expiryPolicy) {
        expiryPolicy = this.getExpiryPolicy(expiryPolicy);
        MapEntries result = new MapEntries();
        for (Data key : keySet) {
            Object value = this.get(key, expiryPolicy);
            if (value == null) continue;
            result.add(key, this.toHeapData(value));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<Data> keys, int completionId) {
        HashSet<Data> keysToClean;
        long now = Clock.currentTimeMillis();
        HashSet<Data> localKeys = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        try {
            this.deleteAllCacheEntry(localKeys);
            keysToClean = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
        }
        catch (Throwable throwable) {
            HashSet<Data> keysToClean2 = new HashSet<Data>(keys.isEmpty() ? this.records.keySet() : keys);
            for (Data key : keysToClean2) {
                this.eventsBatchingEnabled = true;
                CacheRecord record = (CacheRecord)this.records.get(key);
                if (localKeys.contains(key) && record != null) {
                    boolean isExpired = this.processExpiredEntry(key, record, now);
                    if (!isExpired) {
                        this.deleteRecord(key, -1);
                        if (this.isStatisticsEnabled()) {
                            this.statistics.increaseCacheRemovals(1L);
                        }
                    }
                    keys.add(key);
                } else {
                    keys.remove(key);
                }
                this.eventsBatchingEnabled = false;
            }
            int orderKey = keys.hashCode();
            this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
            if (this.isEventsEnabled()) {
                this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(completionId));
            }
            throw throwable;
        }
        for (Data key : keysToClean) {
            this.eventsBatchingEnabled = true;
            CacheRecord record = (CacheRecord)this.records.get(key);
            if (localKeys.contains(key) && record != null) {
                boolean isExpired = this.processExpiredEntry(key, record, now);
                if (!isExpired) {
                    this.deleteRecord(key, -1);
                    if (this.isStatisticsEnabled()) {
                        this.statistics.increaseCacheRemovals(1L);
                    }
                }
                keys.add(key);
            } else {
                keys.remove(key);
            }
            this.eventsBatchingEnabled = false;
        }
        int orderKey = keys.hashCode();
        this.publishBatchedEvents(this.name, CacheEventType.REMOVED, orderKey);
        if (this.isEventsEnabled()) {
            this.publishEvent(CacheEventContextUtil.createCacheCompleteEvent(completionId));
        }
    }

    @Override
    public Set<Data> loadAll(Set<Data> keys, boolean replaceExistingValues) {
        HashSet<Data> keysLoaded = new HashSet<Data>();
        Map<Data, Object> loaded = this.loadAllCacheEntry(keys);
        if (loaded == null || loaded.isEmpty()) {
            return keysLoaded;
        }
        if (replaceExistingValues) {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                this.put(key, value, null, null, false, true, -1);
                keysLoaded.add(key);
            }
        } else {
            for (Map.Entry<Data, Object> entry : loaded.entrySet()) {
                boolean hasPut;
                Data key = entry.getKey();
                Object value = entry.getValue();
                if (value == null || !(hasPut = this.putIfAbsent(key, value, null, null, true, -1))) continue;
                keysLoaded.add(key);
            }
        }
        return keysLoaded;
    }

    @Override
    public CacheKeyIteratorResult iterator(int tableIndex, int size) {
        return this.records.fetchNext(tableIndex, size);
    }

    @Override
    public Object invoke(Data key, EntryProcessor entryProcessor, Object[] arguments, int completionId) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        CacheRecord record = (CacheRecord)this.records.get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (isExpired) {
            record = null;
        }
        if (this.isStatisticsEnabled()) {
            if (this.recordNotExistOrExpired(record, isExpired)) {
                this.statistics.increaseCacheMisses(1L);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
        }
        CacheEntryProcessorEntry entry = this.createCacheEntryProcessorEntry(key, record, now, completionId);
        Object result = entryProcessor.process((MutableEntry)entry, arguments);
        entry.applyChanges();
        return result;
    }

    private boolean recordNotExistOrExpired(R record, boolean isExpired) {
        return record == null || isExpired;
    }

    private boolean recordNotExistOrExpired(R record, long now) {
        return record == null || record.isExpiredAt(now);
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public CacheStatisticsImpl getCacheStats() {
        return this.statistics;
    }

    @Override
    public CacheConfig getConfig() {
        return this.cacheConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<Data, CacheRecord> getReadOnlyRecords() {
        return Collections.unmodifiableMap(this.records);
    }

    @Override
    public void clear() {
        this.records.clear();
        this.onClear();
    }

    protected void onClear() {
        this.invalidateAllEntries();
    }

    @Override
    public void close(boolean onShutdown) {
        this.clear();
        this.closeListeners();
    }

    @Override
    public void destroy() {
        this.clear();
        this.closeListeners();
        this.onDestroy();
    }

    protected void onDestroy() {
    }

    protected void closeListeners() {
        InternalEventService eventService = (InternalEventService)this.cacheService.getNodeEngine().getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", this.name);
        for (EventRegistration eventRegistration : candidates) {
            eventService.close(eventRegistration);
        }
    }

    @Override
    public boolean isWanReplicationEnabled() {
        return this.wanReplicationEnabled;
    }

    protected class MaxSizeEvictionChecker
    implements EvictionChecker {
        protected MaxSizeEvictionChecker() {
        }

        @Override
        public boolean isEvictionRequired() {
            return AbstractCacheRecordStore.this.maxSizeChecker != null && AbstractCacheRecordStore.this.maxSizeChecker.isReachedToMaxSize();
        }
    }
}

