/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import java.util.ArrayList;
import java.util.List;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E> {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList();
    private final List<E> list;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new ArrayList(10));
    }

    private ProtobufArrayList(List<E> list) {
        this.list = list;
    }

    @Override
    public ProtobufArrayList<E> mutableCopyWithCapacity(int n) {
        if (n < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> arrayList = new ArrayList<E>(n);
        arrayList.addAll(this.list);
        return new ProtobufArrayList(arrayList);
    }

    @Override
    public void add(int n, E e) {
        this.ensureIsMutable();
        this.list.add(n, e);
        ++this.modCount;
    }

    @Override
    public E get(int n) {
        return this.list.get(n);
    }

    @Override
    public E remove(int n) {
        this.ensureIsMutable();
        E e = this.list.remove(n);
        ++this.modCount;
        return e;
    }

    @Override
    public E set(int n, E e) {
        this.ensureIsMutable();
        E e2 = this.list.set(n, e);
        ++this.modCount;
        return e2;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

