// Copyright 2015 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.devtools.build.lib.worker;

import com.google.devtools.build.lib.actions.SpawnActionContext;
import com.google.devtools.build.lib.exec.ActionContextConsumer;
import com.google.devtools.build.lib.exec.SpawnActionContextMaps;

/**
 * {@link ActionContextConsumer} that requests the action contexts necessary for worker process
 * execution.
 */
public class WorkerActionContextConsumer implements ActionContextConsumer {

  @Override
  public void populate(SpawnActionContextMaps.Builder builder) {
    builder.strategyByContextMap().put(SpawnActionContext.class, "standalone");
    builder.strategyByContextMap().put(SpawnActionContext.class, "worker");
  }
}
