/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;

@BugPattern(name="EqualsReference", summary="== must be used in equals method to check equality to itself or an infinite loop will occur.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class EqualsReference
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"equals"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.isSameType((String)"java.lang.Object"))}), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.methodReturns((Supplier)Suppliers.BOOLEAN_TYPE), Matchers.methodReturns((Supplier)Suppliers.JAVA_LANG_BOOLEAN_TYPE)})});

    public Description matchMethod(MethodTree methodTree, VisitorState visitorState) {
        if (EQUALS_MATCHER.matches((Tree)methodTree, visitorState)) {
            VariableTree variableTree = methodTree.getParameters().get(0);
            Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)variableTree);
            TreeScannerEquals treeScannerEquals = new TreeScannerEquals(methodTree);
            treeScannerEquals.scan(methodTree.getBody(), varSymbol);
            if (treeScannerEquals.hasIllegalEquals) {
                return this.describeMatch(methodTree);
            }
        }
        return Description.NO_MATCH;
    }

    private static class TreeScannerEquals
    extends TreeScanner<Void, Symbol.VarSymbol> {
        private boolean hasIllegalEquals = false;
        private MethodTree methodTree;

        public TreeScannerEquals(MethodTree currMethodTree) {
            this.methodTree = currMethodTree;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Symbol.VarSymbol varSymbol) {
            boolean hasParameterAndSameSymbol;
            ExpressionTree methodSelectTree = methodInvocationTree.getMethodSelect();
            boolean bl = hasParameterAndSameSymbol = methodInvocationTree.getArguments().size() == 1 && Objects.equals(ASTHelpers.getSymbol((Tree)methodInvocationTree.getArguments().get(0)), varSymbol);
            if (methodSelectTree instanceof MemberSelectTree) {
                MemberSelectTree memberSelectTree = (MemberSelectTree)methodSelectTree;
                if (memberSelectTree.getExpression().toString().equals("this") && Objects.equals(ASTHelpers.getSymbol((MethodTree)this.methodTree), ASTHelpers.getSymbol((Tree)memberSelectTree)) && hasParameterAndSameSymbol) {
                    this.hasIllegalEquals = true;
                }
            } else if (methodInvocationTree.getMethodSelect() instanceof IdentifierTree) {
                IdentifierTree methodSelect = (IdentifierTree)methodInvocationTree.getMethodSelect();
                if (Objects.equals(ASTHelpers.getSymbol((MethodTree)this.methodTree), ASTHelpers.getSymbol((Tree)methodSelect)) && hasParameterAndSameSymbol) {
                    this.hasIllegalEquals = true;
                }
            }
            return (Void)super.visitMethodInvocation(methodInvocationTree, varSymbol);
        }
    }
}

