/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.UnsafeProvider;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;

public class UnsafeJdk9StringCodec
implements ObjectCodec<String> {
    private final Constructor<String> constructor;
    private final long valueOffset;
    private final long coderOffset;

    @VisibleForTesting
    public static boolean canUseUnsafeCodec() {
        return UnsafeJdk9StringCodec.getVersion() > 1.8;
    }

    private static double getVersion() {
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        pos = version.indexOf(46, pos + 1);
        return Double.parseDouble(version.substring(0, pos));
    }

    public UnsafeJdk9StringCodec() {
        Field coderField;
        Field valueField;
        try {
            this.constructor = String.class.getDeclaredConstructor(byte[].class, Byte.TYPE);
            valueField = String.class.getDeclaredField("value");
            coderField = String.class.getDeclaredField("coder");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Bad fields/constructor: " + Arrays.toString(String.class.getDeclaredConstructors()) + ", " + Arrays.toString(String.class.getDeclaredFields()), e);
        }
        this.constructor.setAccessible(true);
        valueField.setAccessible(true);
        this.valueOffset = UnsafeProvider.getInstance().objectFieldOffset(valueField);
        coderField.setAccessible(true);
        this.coderOffset = UnsafeProvider.getInstance().objectFieldOffset(coderField);
    }

    @Override
    public Class<? extends String> getEncodedClass() {
        return String.class;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE;
    }

    @Override
    public void serialize(SerializationContext context, String obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        byte coder = UnsafeProvider.getInstance().getByte(obj, this.coderOffset);
        byte[] value = (byte[])UnsafeProvider.getInstance().getObject(obj, this.valueOffset);
        if (coder == 0) {
            codedOut.writeInt32NoTag(value.length);
        } else if (coder == 1) {
            codedOut.writeInt32NoTag(-value.length);
        } else {
            throw new SerializationException("Unexpected coder value: " + coder + " for " + obj);
        }
        codedOut.writeRawBytes(value);
    }

    @Override
    public String deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        byte coder;
        int length = codedIn.readInt32();
        if (length >= 0) {
            coder = 0;
        } else {
            coder = 1;
            length = -length;
        }
        byte[] value = codedIn.readRawBytes(length);
        try {
            return this.constructor.newInstance(value, coder);
        }
        catch (ReflectiveOperationException e) {
            throw new SerializationException("Could not instantiate string: " + Arrays.toString(value) + ", " + coder, e);
        }
    }
}

