/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ImmutableSetRuntimeCodec
implements ObjectCodec<ImmutableSet> {
    ImmutableSetRuntimeCodec() {
    }

    @Override
    public Class<ImmutableSet> getEncodedClass() {
        return ImmutableSet.class;
    }

    @Override
    public void serialize(SerializationContext context, ImmutableSet object, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(object.size());
        for (Object obj : object) {
            context.serialize(obj, codedOut);
        }
    }

    @Override
    public ImmutableSet deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            Object item = context.deserialize(codedIn);
            builder.add(item);
        }
        return builder.build();
    }
}

