/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheContext;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CacheEntryCountResolver {
    public abstract long getEntryCount();

    public abstract void setEntryCount(long var1);

    public abstract long increaseEntryCount();

    public abstract long increaseEntryCount(long var1);

    public abstract long decreaseEntryCount();

    public abstract long decreaseEntryCount(long var1);

    public static CacheEntryCountResolver createEntryCountResolver() {
        return new DefaultEntryCountResolver();
    }

    public static CacheEntryCountResolver createEntryCountResolver(CacheContext cacheContext) {
        return new CacheContextBackedEntryCountResolver(cacheContext);
    }

    private static class CacheContextBackedEntryCountResolver
    extends CacheEntryCountResolver {
        private final CacheContext cacheContext;

        public CacheContextBackedEntryCountResolver(CacheContext cacheContext) {
            this.cacheContext = cacheContext;
        }

        @Override
        public long getEntryCount() {
            return this.cacheContext.getEntryCount();
        }

        @Override
        public void setEntryCount(long count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long increaseEntryCount() {
            return this.cacheContext.increaseEntryCount();
        }

        @Override
        public long increaseEntryCount(long count) {
            return this.cacheContext.increaseEntryCount(count);
        }

        @Override
        public long decreaseEntryCount() {
            return this.cacheContext.decreaseEntryCount();
        }

        @Override
        public long decreaseEntryCount(long count) {
            return this.cacheContext.decreaseEntryCount(count);
        }
    }

    private static class DefaultEntryCountResolver
    extends CacheEntryCountResolver {
        private final AtomicLong entryCount = new AtomicLong(0L);

        private DefaultEntryCountResolver() {
        }

        @Override
        public long getEntryCount() {
            return this.entryCount.get();
        }

        @Override
        public void setEntryCount(long count) {
            this.entryCount.set(count);
        }

        @Override
        public long increaseEntryCount() {
            return this.entryCount.incrementAndGet();
        }

        @Override
        public long increaseEntryCount(long count) {
            return this.entryCount.addAndGet(count);
        }

        @Override
        public long decreaseEntryCount() {
            return this.entryCount.decrementAndGet();
        }

        @Override
        public long decreaseEntryCount(long count) {
            return this.entryCount.addAndGet(-count);
        }
    }
}

