/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeParameterShadowing;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.NamingConventions;
import com.sun.source.tree.TypeParameterTree;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="TypeParameterNaming", summary="Type parameters must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"}, linkType=BugPattern.LinkType.CUSTOM, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, link="https://google.github.io/styleguide/javaguide.html#s5.2.8-type-variable-names")
public class TypeParameterNaming
extends BugChecker
implements BugChecker.TypeParameterTreeMatcher {
    private static final Pattern SINGLE_PLUS_MAYBE_DIGIT = Pattern.compile("[A-Z]\\d?");

    private static String upperCamelToken(String s) {
        return "" + Ascii.toUpperCase((char)s.charAt(0)) + (s.length() == 1 ? "" : s.substring(1));
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        if (TypeParameterNaming.matchesTypeParameterNamingScheme(tree.getName())) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Type Parameter %s must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", tree.getName())).addFix((Fix)TypeParameterShadowing.renameTypeVariable(tree, state.getPath().getParentPath().getLeaf(), TypeParameterNaming.replacementName(tree.getName().toString()), state)).build();
    }

    static boolean matchesTypeParameterNamingScheme(Name name) {
        return SINGLE_PLUS_MAYBE_DIGIT.matcher(name).matches() || TypeParameterNaming.matchesClassWithT(name.toString());
    }

    private static String replacementName(String identifier) {
        String token;
        Preconditions.checkArgument((!identifier.isEmpty() ? 1 : 0) != 0);
        if (identifier.length() > 2 && identifier.charAt(0) == 'T' && Ascii.isUpperCase((char)identifier.charAt(1)) && Ascii.isLowerCase((char)identifier.charAt(2))) {
            ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier.substring(1));
            return Streams.concat((Stream[])new Stream[]{tokens.stream(), Stream.of("T")}).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier);
        if (tokens.size() == 1 && (token = (String)tokens.get(0)).toUpperCase().equals(identifier)) {
            return TypeParameterNaming.upperCamelToken(token) + "T";
        }
        if (((String)Iterables.getLast((Iterable)tokens)).equals("type")) {
            return Streams.concat((Stream[])new Stream[]{tokens.subList(0, tokens.size() - 1).stream(), Stream.of("T")}).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        return identifier + "T";
    }

    @VisibleForTesting
    static boolean matchesClassWithT(String identifier) {
        if (!identifier.endsWith("T")) {
            return false;
        }
        ImmutableList tokens = NamingConventions.splitToLowercaseTerms((String)identifier);
        String reassembled = tokens.stream().map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        return identifier.equals(reassembled);
    }
}

