/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class MigrationQueue {
    private final AtomicInteger migrateTaskCount = new AtomicInteger();
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

    MigrationQueue() {
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="offer will always be successful since queue is unbounded")
    public void add(Runnable task) {
        if (task instanceof InternalPartitionServiceImpl.MigrateTask) {
            this.migrateTaskCount.incrementAndGet();
        }
        this.queue.offer(task);
    }

    public Runnable poll(int timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll(timeout, unit);
    }

    public void clear() {
        ArrayList sink = new ArrayList();
        this.queue.drainTo(sink);
        for (Runnable task : sink) {
            this.afterTaskCompletion(task);
        }
    }

    public void afterTaskCompletion(Runnable task) {
        if (task instanceof InternalPartitionServiceImpl.MigrateTask && this.migrateTaskCount.decrementAndGet() < 0) {
            throw new IllegalStateException();
        }
    }

    public boolean hasMigrationTasks() {
        return this.migrateTaskCount.get() > 0;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isNonEmpty() {
        return !this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }
}

