/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TurbineOptions {
    private final String output;
    private final ImmutableList<String> classPath;
    private final ImmutableSet<String> bootClassPath;
    private final Optional<String> release;
    private final Optional<String> system;
    private final ImmutableList<String> sources;
    private final ImmutableList<String> processorPath;
    private final ImmutableSet<String> processors;
    private final ImmutableList<String> sourceJars;
    private final Optional<String> outputDeps;
    private final ImmutableSet<String> directJars;
    private final Optional<String> targetLabel;
    private final Optional<String> injectingRuleKind;
    private final ImmutableList<String> depsArtifacts;
    private final boolean javacFallback;
    private final ImmutableList<String> javacOpts;
    private final boolean shouldReduceClassPath;

    private TurbineOptions(String output, ImmutableList<String> classPath, ImmutableSet<String> bootClassPath, String release, String system, ImmutableList<String> sources, ImmutableList<String> processorPath, ImmutableSet<String> processors, ImmutableList<String> sourceJars, @Nullable String outputDeps, ImmutableSet<String> directJars, @Nullable String targetLabel, @Nullable String injectingRuleKind, ImmutableList<String> depsArtifacts, boolean javacFallback, ImmutableList<String> javacOpts, boolean shouldReduceClassPath) {
        this.output = (String)Preconditions.checkNotNull((Object)output, (Object)"output must not be null");
        this.classPath = (ImmutableList)Preconditions.checkNotNull(classPath, (Object)"classPath must not be null");
        this.bootClassPath = (ImmutableSet)Preconditions.checkNotNull(bootClassPath, (Object)"bootClassPath must not be null");
        this.release = Optional.fromNullable((Object)release);
        this.system = Optional.fromNullable((Object)system);
        this.sources = (ImmutableList)Preconditions.checkNotNull(sources, (Object)"sources must not be null");
        this.processorPath = (ImmutableList)Preconditions.checkNotNull(processorPath, (Object)"processorPath must not be null");
        this.processors = (ImmutableSet)Preconditions.checkNotNull(processors, (Object)"processors must not be null");
        this.sourceJars = (ImmutableList)Preconditions.checkNotNull(sourceJars, (Object)"sourceJars must not be null");
        this.outputDeps = Optional.fromNullable((Object)outputDeps);
        this.directJars = (ImmutableSet)Preconditions.checkNotNull(directJars, (Object)"directJars must not be null");
        this.targetLabel = Optional.fromNullable((Object)targetLabel);
        this.injectingRuleKind = Optional.fromNullable((Object)injectingRuleKind);
        this.depsArtifacts = (ImmutableList)Preconditions.checkNotNull(depsArtifacts, (Object)"depsArtifacts must not be null");
        this.javacFallback = javacFallback;
        this.javacOpts = (ImmutableList)Preconditions.checkNotNull(javacOpts, (Object)"javacOpts must not be null");
        this.shouldReduceClassPath = shouldReduceClassPath;
    }

    public ImmutableList<String> sources() {
        return this.sources;
    }

    public ImmutableList<String> classPath() {
        return this.classPath;
    }

    public ImmutableSet<String> bootClassPath() {
        return this.bootClassPath;
    }

    public Optional<String> release() {
        return this.release;
    }

    public Optional<String> system() {
        return this.system;
    }

    public String outputFile() {
        return this.output;
    }

    public ImmutableList<String> processorPath() {
        return this.processorPath;
    }

    public ImmutableSet<String> processors() {
        return this.processors;
    }

    public ImmutableList<String> sourceJars() {
        return this.sourceJars;
    }

    public Optional<String> outputDeps() {
        return this.outputDeps;
    }

    public ImmutableSet<String> directJars() {
        return this.directJars;
    }

    public Optional<String> targetLabel() {
        return this.targetLabel;
    }

    public Optional<String> injectingRuleKind() {
        return this.injectingRuleKind;
    }

    public ImmutableList<String> depsArtifacts() {
        return this.depsArtifacts;
    }

    public boolean javacFallback() {
        return this.javacFallback;
    }

    public ImmutableList<String> javacOpts() {
        return this.javacOpts;
    }

    public boolean shouldReduceClassPath() {
        return this.shouldReduceClassPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String output;
        private final ImmutableList.Builder<String> classPath = ImmutableList.builder();
        private final ImmutableList.Builder<String> sources = ImmutableList.builder();
        private final ImmutableList.Builder<String> processorPath = ImmutableList.builder();
        private final ImmutableSet.Builder<String> processors = ImmutableSet.builder();
        private final ImmutableList.Builder<String> sourceJars = ImmutableList.builder();
        private final ImmutableSet.Builder<String> bootClassPath = ImmutableSet.builder();
        private @Nullable String release;
        private @Nullable String system;
        private String outputDeps;
        private final ImmutableSet.Builder<String> directJars = ImmutableSet.builder();
        private @Nullable String targetLabel;
        private @Nullable String injectingRuleKind;
        private final ImmutableList.Builder<String> depsArtifacts = ImmutableList.builder();
        private boolean javacFallback = true;
        private final ImmutableList.Builder<String> javacOpts = ImmutableList.builder();
        private boolean shouldReduceClassPath = true;

        public TurbineOptions build() {
            return new TurbineOptions(this.output, this.classPath.build(), this.bootClassPath.build(), this.release, this.system, this.sources.build(), this.processorPath.build(), this.processors.build(), this.sourceJars.build(), this.outputDeps, this.directJars.build(), this.targetLabel, this.injectingRuleKind, this.depsArtifacts.build(), this.javacFallback, this.javacOpts.build(), this.shouldReduceClassPath);
        }

        public Builder setOutput(String output) {
            this.output = output;
            return this;
        }

        public Builder addClassPathEntries(Iterable<String> classPath) {
            this.classPath.addAll(classPath);
            return this;
        }

        public Builder addBootClassPathEntries(Iterable<String> bootClassPath) {
            this.bootClassPath.addAll(bootClassPath);
            return this;
        }

        public Builder setRelease(String release) {
            this.release = release;
            return this;
        }

        public Builder setSystem(String system) {
            this.system = system;
            return this;
        }

        public Builder addSources(Iterable<String> sources) {
            this.sources.addAll(sources);
            return this;
        }

        public Builder addProcessorPathEntries(Iterable<String> processorPath) {
            this.processorPath.addAll(processorPath);
            return this;
        }

        public Builder addProcessors(Iterable<String> processors) {
            this.processors.addAll(processors);
            return this;
        }

        public Builder setTempDir(String tempDir) {
            return this;
        }

        public Builder setSourceJars(Iterable<String> sourceJars) {
            this.sourceJars.addAll(sourceJars);
            return this;
        }

        public Builder setOutputDeps(String outputDeps) {
            this.outputDeps = outputDeps;
            return this;
        }

        public Builder setTargetLabel(String targetLabel) {
            this.targetLabel = targetLabel;
            return this;
        }

        public Builder setInjectingRuleKind(String injectingRuleKind) {
            this.injectingRuleKind = injectingRuleKind;
            return this;
        }

        public Builder addAllDepsArtifacts(Iterable<String> depsArtifacts) {
            this.depsArtifacts.addAll(depsArtifacts);
            return this;
        }

        public Builder setJavacFallback(boolean javacFallback) {
            this.javacFallback = javacFallback;
            return this;
        }

        public Builder addAllJavacOpts(Iterable<String> javacOpts) {
            this.javacOpts.addAll(javacOpts);
            return this;
        }

        public Builder setShouldReduceClassPath(boolean shouldReduceClassPath) {
            this.shouldReduceClassPath = shouldReduceClassPath;
            return this;
        }

        public Builder addDirectJars(ImmutableList<String> jars) {
            this.directJars.addAll(jars);
            return this;
        }
    }
}

