/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.model;

public enum TurbineVisibility {
    PUBLIC(3, 1),
    PROTECTED(2, 4),
    PACKAGE(1, 0),
    PRIVATE(0, 2);

    private final int level;
    private final int flag;
    public static final int VISIBILITY_MASK = 7;

    private TurbineVisibility(int level, int flag) {
        this.level = level;
        this.flag = flag;
    }

    public boolean moreVisible(TurbineVisibility other) {
        return this.level > other.level;
    }

    public int flag() {
        return this.flag;
    }

    public static TurbineVisibility fromAccess(int access) {
        switch (access & 7) {
            case 1: {
                return PUBLIC;
            }
            case 2: {
                return PRIVATE;
            }
            case 4: {
                return PROTECTED;
            }
            case 0: {
                return PACKAGE;
            }
        }
        throw new AssertionError((Object)String.format("0x%x", access));
    }

    public int setAccess(int access) {
        access &= 0xFFFFFFF8;
        return access |= this.flag();
    }
}

