/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.UnsafeUtil;
import java.nio.ByteBuffer;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    public static boolean isValidUtf8(byte[] byArray) {
        return processor.isValidUtf8(byArray, 0, byArray.length);
    }

    public static boolean isValidUtf8(byte[] byArray, int n, int n2) {
        return processor.isValidUtf8(byArray, n, n2);
    }

    public static int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
        return processor.partialIsValidUtf8(n, byArray, n2, n3);
    }

    private static int incompleteStateFor(int n) {
        return n > -12 ? -1 : n;
    }

    private static int incompleteStateFor(int n, int n2) {
        return n > -12 || n2 > -65 ? -1 : n ^ n2 << 8;
    }

    private static int incompleteStateFor(int n, int n2, int n3) {
        return n > -12 || n2 > -65 || n3 > -65 ? -1 : n ^ n2 << 8 ^ n3 << 16;
    }

    private static int incompleteStateFor(byte[] byArray, int n, int n2) {
        byte by = byArray[n - 1];
        switch (n2 - n) {
            case 0: {
                return Utf8.incompleteStateFor(by);
            }
            case 1: {
                return Utf8.incompleteStateFor(by, byArray[n]);
            }
            case 2: {
                return Utf8.incompleteStateFor(by, (int)byArray[n], (int)byArray[n + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer byteBuffer, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return Utf8.incompleteStateFor(n);
            }
            case 1: {
                return Utf8.incompleteStateFor(n, byteBuffer.get(n2));
            }
            case 2: {
                return Utf8.incompleteStateFor(n, (int)byteBuffer.get(n2), (int)byteBuffer.get(n2 + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += Utf8.encodedLengthGeneral(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new UnpairedSurrogateException(i, n2);
            }
            ++i;
        }
        return n3;
    }

    static int encode(CharSequence charSequence, byte[] byArray, int n, int n2) {
        return processor.encodeUtf8(charSequence, byArray, n, n2);
    }

    static boolean isValidUtf8(ByteBuffer byteBuffer) {
        return processor.isValidUtf8(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    static int partialIsValidUtf8(int n, ByteBuffer byteBuffer, int n2, int n3) {
        return processor.partialIsValidUtf8(n, byteBuffer, n2, n3);
    }

    static void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
        processor.encodeUtf8(charSequence, byteBuffer);
    }

    private static int estimateConsecutiveAscii(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        int n4 = n2 - 7;
        for (n3 = n; n3 < n4 && (byteBuffer.getLong(n3) & 0x8080808080808080L) == 0L; n3 += 8) {
        }
        return n3 - n;
    }

    private Utf8() {
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
            if ((n2 | n3 | byArray.length - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", byArray.length, n2, n3));
            }
            long l = n2;
            long l2 = n3;
            if (n != 0) {
                if (l >= l2) {
                    return n;
                }
                byte by = (byte)n;
                if (by < -32) {
                    if (by < -62 || UnsafeUtil.getByte(byArray, l++) > -65) {
                        return -1;
                    }
                } else if (by < -16) {
                    byte by2 = (byte)(~(n >> 8));
                    if (by2 == 0) {
                        by2 = UnsafeUtil.getByte(byArray, l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by2);
                        }
                    }
                    if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || UnsafeUtil.getByte(byArray, l++) > -65) {
                        return -1;
                    }
                } else {
                    byte by3 = (byte)(~(n >> 8));
                    byte by4 = 0;
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(byArray, l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by3);
                        }
                    } else {
                        by4 = (byte)(n >> 16);
                    }
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(byArray, l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by3, by4);
                        }
                    }
                    if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || UnsafeUtil.getByte(byArray, l++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(byArray, l, (int)(l2 - l));
        }

        @Override
        int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
            if ((n2 | n3 | byteBuffer.limit() - n3) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", byteBuffer.limit(), n2, n3));
            }
            long l = UnsafeUtil.addressOffset(byteBuffer) + (long)n2;
            long l2 = l + (long)(n3 - n2);
            if (n != 0) {
                if (l >= l2) {
                    return n;
                }
                byte by = (byte)n;
                if (by < -32) {
                    if (by < -62 || UnsafeUtil.getByte(l++) > -65) {
                        return -1;
                    }
                } else if (by < -16) {
                    byte by2 = (byte)(~(n >> 8));
                    if (by2 == 0) {
                        by2 = UnsafeUtil.getByte(l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by2);
                        }
                    }
                    if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || UnsafeUtil.getByte(l++) > -65) {
                        return -1;
                    }
                } else {
                    byte by3 = (byte)(~(n >> 8));
                    byte by4 = 0;
                    if (by3 == 0) {
                        by3 = UnsafeUtil.getByte(l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by3);
                        }
                    } else {
                        by4 = (byte)(n >> 16);
                    }
                    if (by4 == 0) {
                        by4 = UnsafeUtil.getByte(l++);
                        if (l >= l2) {
                            return Utf8.incompleteStateFor(by, by3, by4);
                        }
                    }
                    if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || UnsafeUtil.getByte(l++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(l, (int)(l2 - l));
        }

        @Override
        int encodeUtf8(CharSequence charSequence, byte[] byArray, int n, int n2) {
            char c;
            int n3;
            long l = n;
            long l2 = l + (long)n2;
            int n4 = charSequence.length();
            if (n4 > n2 || byArray.length - n2 < n) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n4 - 1) + " at index " + (n + n2));
            }
            for (n3 = 0; n3 < n4 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
                UnsafeUtil.putByte(byArray, l++, (byte)c);
            }
            if (n3 == n4) {
                return (int)l;
            }
            while (n3 < n4) {
                c = charSequence.charAt(n3);
                if (c < '\u0080' && l < l2) {
                    UnsafeUtil.putByte(byArray, l++, (byte)c);
                } else if (c < '\u0800' && l <= l2 - 2L) {
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && l <= l2 - 3L) {
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & c));
                } else if (l <= l2 - 4L) {
                    char c2;
                    if (n3 + 1 == n4 || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                        throw new UnpairedSurrogateException(n3 - 1, n4);
                    }
                    int n5 = Character.toCodePoint(c, c2);
                    UnsafeUtil.putByte(byArray, l++, (byte)(0xF0 | n5 >>> 18));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n5 >>> 12));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n5 >>> 6));
                    UnsafeUtil.putByte(byArray, l++, (byte)(0x80 | 0x3F & n5));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || n3 + 1 != n4 && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                        throw new UnpairedSurrogateException(n3, n4);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + l);
                }
                ++n3;
            }
            return (int)l;
        }

        @Override
        void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
            char c;
            int n;
            long l = UnsafeUtil.addressOffset(byteBuffer);
            long l2 = l + (long)byteBuffer.position();
            long l3 = l + (long)byteBuffer.limit();
            int n2 = charSequence.length();
            if ((long)n2 > l3 - l2) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n2 - 1) + " at index " + byteBuffer.limit());
            }
            for (n = 0; n < n2 && (c = charSequence.charAt(n)) < '\u0080'; ++n) {
                UnsafeUtil.putByte(l2++, (byte)c);
            }
            if (n == n2) {
                byteBuffer.position((int)(l2 - l));
                return;
            }
            while (n < n2) {
                c = charSequence.charAt(n);
                if (c < '\u0080' && l2 < l3) {
                    UnsafeUtil.putByte(l2++, (byte)c);
                } else if (c < '\u0800' && l2 <= l3 - 2L) {
                    UnsafeUtil.putByte(l2++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && l2 <= l3 - 3L) {
                    UnsafeUtil.putByte(l2++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & c));
                } else if (l2 <= l3 - 4L) {
                    char c2;
                    if (n + 1 == n2 || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n))) {
                        throw new UnpairedSurrogateException(n - 1, n2);
                    }
                    int n3 = Character.toCodePoint(c, c2);
                    UnsafeUtil.putByte(l2++, (byte)(0xF0 | n3 >>> 18));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n3 >>> 12));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n3 >>> 6));
                    UnsafeUtil.putByte(l2++, (byte)(0x80 | 0x3F & n3));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || n + 1 != n2 && Character.isSurrogatePair(c, charSequence.charAt(n + 1)))) {
                        throw new UnpairedSurrogateException(n, n2);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + l2);
                }
                ++n;
            }
            byteBuffer.position((int)(l2 - l));
        }

        private static int unsafeEstimateConsecutiveAscii(byte[] byArray, long l, int n) {
            if (n < 16) {
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                if (UnsafeUtil.getByte(byArray, l++) >= 0) continue;
                return i;
            }
            return n;
        }

        private static int unsafeEstimateConsecutiveAscii(long l, int n) {
            int n2;
            int n3 = n;
            if (n3 < 16) {
                return 0;
            }
            for (int i = n2 = (int)l & 7; i > 0; --i) {
                if (UnsafeUtil.getByte(l++) >= 0) continue;
                return n2 - i;
            }
            n3 -= n2;
            while (n3 >= 8 && (UnsafeUtil.getLong(l) & 0x8080808080808080L) == 0L) {
                l += 8L;
                n3 -= 8;
            }
            return n - n3;
        }

        private static int partialIsValidUtf8(byte[] byArray, long l, int n) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(byArray, l, n);
            n -= n2;
            l += (long)n2;
            while (true) {
                byte by;
                int n3 = 0;
                while (n > 0) {
                    byte by2 = UnsafeUtil.getByte(byArray, l++);
                    n3 = by2;
                    if (by2 < 0) break;
                    --n;
                }
                if (n == 0) {
                    return 0;
                }
                --n;
                if (n3 < -32) {
                    if (n == 0) {
                        return n3;
                    }
                    --n;
                    if (n3 >= -62 && UnsafeUtil.getByte(byArray, l++) <= -65) continue;
                    return -1;
                }
                if (n3 < -16) {
                    if (n < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n3, l, n);
                    }
                    n -= 2;
                    if (!((by = UnsafeUtil.getByte(byArray, l++)) > -65 || n3 == -32 && by < -96 || n3 == -19 && by >= -96) && UnsafeUtil.getByte(byArray, l++) <= -65) continue;
                    return -1;
                }
                if (n < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n3, l, n);
                }
                n -= 3;
                if ((by = UnsafeUtil.getByte(byArray, l++)) > -65 || (n3 << 28) + (by - -112) >> 30 != 0 || UnsafeUtil.getByte(byArray, l++) > -65 || UnsafeUtil.getByte(byArray, l++) > -65) break;
            }
            return -1;
        }

        private static int partialIsValidUtf8(long l, int n) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(l, n);
            l += (long)n2;
            n -= n2;
            while (true) {
                byte by;
                int n3 = 0;
                while (n > 0) {
                    byte by2 = UnsafeUtil.getByte(l++);
                    n3 = by2;
                    if (by2 < 0) break;
                    --n;
                }
                if (n == 0) {
                    return 0;
                }
                --n;
                if (n3 < -32) {
                    if (n == 0) {
                        return n3;
                    }
                    --n;
                    if (n3 >= -62 && UnsafeUtil.getByte(l++) <= -65) continue;
                    return -1;
                }
                if (n3 < -16) {
                    if (n < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(l, n3, n);
                    }
                    n -= 2;
                    if (!((by = UnsafeUtil.getByte(l++)) > -65 || n3 == -32 && by < -96 || n3 == -19 && by >= -96) && UnsafeUtil.getByte(l++) <= -65) continue;
                    return -1;
                }
                if (n < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(l, n3, n);
                }
                n -= 3;
                if ((by = UnsafeUtil.getByte(l++)) > -65 || (n3 << 28) + (by - -112) >> 30 != 0 || UnsafeUtil.getByte(l++) > -65 || UnsafeUtil.getByte(l++) > -65) break;
            }
            return -1;
        }

        private static int unsafeIncompleteStateFor(byte[] byArray, int n, long l, int n2) {
            switch (n2) {
                case 0: {
                    return Utf8.incompleteStateFor(n);
                }
                case 1: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(byArray, l));
                }
                case 2: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(byArray, l), UnsafeUtil.getByte(byArray, l + 1L));
                }
            }
            throw new AssertionError();
        }

        private static int unsafeIncompleteStateFor(long l, int n, int n2) {
            switch (n2) {
                case 0: {
                    return Utf8.incompleteStateFor(n);
                }
                case 1: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(l));
                }
                case 2: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(l), UnsafeUtil.getByte(l + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        @Override
        int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
            if (n != 0) {
                if (n2 >= n3) {
                    return n;
                }
                byte by = (byte)n;
                if (by < -32) {
                    if (by < -62 || byArray[n2++] > -65) {
                        return -1;
                    }
                } else if (by < -16) {
                    byte by2 = (byte)(~(n >> 8));
                    if (by2 == 0) {
                        by2 = byArray[n2++];
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by2);
                        }
                    }
                    if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || byArray[n2++] > -65) {
                        return -1;
                    }
                } else {
                    byte by3 = (byte)(~(n >> 8));
                    byte by4 = 0;
                    if (by3 == 0) {
                        by3 = byArray[n2++];
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by3);
                        }
                    } else {
                        by4 = (byte)(n >> 16);
                    }
                    if (by4 == 0) {
                        by4 = byArray[n2++];
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by3, by4);
                        }
                    }
                    if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || byArray[n2++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8(byArray, n2, n3);
        }

        @Override
        int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
            return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
        }

        @Override
        int encodeUtf8(CharSequence charSequence, byte[] byArray, int n, int n2) {
            char c;
            int n3;
            int n4 = charSequence.length();
            int n5 = n;
            int n6 = n + n2;
            for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
                byArray[n5 + n3] = (byte)c;
            }
            if (n3 == n4) {
                return n5 + n4;
            }
            n5 += n3;
            while (n3 < n4) {
                c = charSequence.charAt(n3);
                if (c < '\u0080' && n5 < n6) {
                    byArray[n5++] = (byte)c;
                } else if (c < '\u0800' && n5 <= n6 - 2) {
                    byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                    byArray[n5++] = (byte)(0x80 | 0x3F & c);
                } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                    byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                    byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                    byArray[n5++] = (byte)(0x80 | 0x3F & c);
                } else if (n5 <= n6 - 4) {
                    char c2;
                    if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                        throw new UnpairedSurrogateException(n3 - 1, n4);
                    }
                    int n7 = Character.toCodePoint(c, c2);
                    byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                    byArray[n5++] = (byte)(0x80 | 0x3F & n7);
                } else {
                    if (!('\ud800' > c || c > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                        throw new UnpairedSurrogateException(n3, n4);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
                }
                ++n3;
            }
            return n5;
        }

        @Override
        void encodeUtf8Direct(CharSequence charSequence, ByteBuffer byteBuffer) {
            this.encodeUtf8Default(charSequence, byteBuffer);
        }

        private static int partialIsValidUtf8(byte[] byArray, int n, int n2) {
            while (n < n2 && byArray[n] >= 0) {
                ++n;
            }
            return n >= n2 ? 0 : SafeProcessor.partialIsValidUtf8NonAscii(byArray, n, n2);
        }

        private static int partialIsValidUtf8NonAscii(byte[] byArray, int n, int n2) {
            while (true) {
                byte by;
                byte by2;
                if (n >= n2) {
                    return 0;
                }
                if ((by2 = byArray[n++]) >= 0) continue;
                if (by2 < -32) {
                    if (n >= n2) {
                        return by2;
                    }
                    if (by2 >= -62 && byArray[n++] <= -65) continue;
                    return -1;
                }
                if (by2 < -16) {
                    if (n >= n2 - 1) {
                        return Utf8.incompleteStateFor(byArray, n, n2);
                    }
                    if (!((by = byArray[n++]) > -65 || by2 == -32 && by < -96 || by2 == -19 && by >= -96) && byArray[n++] <= -65) continue;
                    return -1;
                }
                if (n >= n2 - 2) {
                    return Utf8.incompleteStateFor(byArray, n, n2);
                }
                if ((by = byArray[n++]) > -65 || (by2 << 28) + (by - -112) >> 30 != 0 || byArray[n++] > -65 || byArray[n++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        final boolean isValidUtf8(byte[] byArray, int n, int n2) {
            return this.partialIsValidUtf8(0, byArray, n, n2) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        final boolean isValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
            return this.partialIsValidUtf8(0, byteBuffer, n, n2) == 0;
        }

        final int partialIsValidUtf8(int n, ByteBuffer byteBuffer, int n2, int n3) {
            if (byteBuffer.hasArray()) {
                int n4 = byteBuffer.arrayOffset();
                return this.partialIsValidUtf8(n, byteBuffer.array(), n4 + n2, n4 + n3);
            }
            if (byteBuffer.isDirect()) {
                return this.partialIsValidUtf8Direct(n, byteBuffer, n2, n3);
            }
            return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final int partialIsValidUtf8Default(int n, ByteBuffer byteBuffer, int n2, int n3) {
            if (n != 0) {
                if (n2 >= n3) {
                    return n;
                }
                byte by = (byte)n;
                if (by < -32) {
                    if (by < -62 || byteBuffer.get(n2++) > -65) {
                        return -1;
                    }
                } else if (by < -16) {
                    byte by2 = (byte)(~(n >> 8));
                    if (by2 == 0) {
                        by2 = byteBuffer.get(n2++);
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by2);
                        }
                    }
                    if (by2 > -65 || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || byteBuffer.get(n2++) > -65) {
                        return -1;
                    }
                } else {
                    byte by3 = (byte)(~(n >> 8));
                    byte by4 = 0;
                    if (by3 == 0) {
                        by3 = byteBuffer.get(n2++);
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by3);
                        }
                    } else {
                        by4 = (byte)(n >> 16);
                    }
                    if (by4 == 0) {
                        by4 = byteBuffer.get(n2++);
                        if (n2 >= n3) {
                            return Utf8.incompleteStateFor(by, by3, by4);
                        }
                    }
                    if (by3 > -65 || (by << 28) + (by3 - -112) >> 30 != 0 || by4 > -65 || byteBuffer.get(n2++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(byteBuffer, n2, n3);
        }

        private static int partialIsValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
            n += Utf8.estimateConsecutiveAscii(byteBuffer, n, n2);
            while (true) {
                byte by;
                byte by2;
                if (n >= n2) {
                    return 0;
                }
                if ((by2 = byteBuffer.get(n++)) >= 0) continue;
                if (by2 < -32) {
                    if (n >= n2) {
                        return by2;
                    }
                    if (by2 < -62 || byteBuffer.get(n) > -65) {
                        return -1;
                    }
                    ++n;
                    continue;
                }
                if (by2 < -16) {
                    if (n >= n2 - 1) {
                        return Utf8.incompleteStateFor(byteBuffer, by2, n, n2 - n);
                    }
                    if ((by = byteBuffer.get(n++)) > -65 || by2 == -32 && by < -96 || by2 == -19 && by >= -96 || byteBuffer.get(n) > -65) {
                        return -1;
                    }
                    ++n;
                    continue;
                }
                if (n >= n2 - 2) {
                    return Utf8.incompleteStateFor(byteBuffer, by2, n, n2 - n);
                }
                if ((by = byteBuffer.get(n++)) > -65 || (by2 << 28) + (by - -112) >> 30 != 0 || byteBuffer.get(n++) > -65 || byteBuffer.get(n++) > -65) break;
            }
            return -1;
        }

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        final void encodeUtf8(CharSequence charSequence, ByteBuffer byteBuffer) {
            if (byteBuffer.hasArray()) {
                int n = byteBuffer.arrayOffset();
                int n2 = Utf8.encode(charSequence, byteBuffer.array(), n + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n2 - n);
            } else if (byteBuffer.isDirect()) {
                this.encodeUtf8Direct(charSequence, byteBuffer);
            } else {
                this.encodeUtf8Default(charSequence, byteBuffer);
            }
        }

        abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

        final void encodeUtf8Default(CharSequence charSequence, ByteBuffer byteBuffer) {
            int n;
            int n2 = charSequence.length();
            int n3 = byteBuffer.position();
            try {
                char c;
                for (n = 0; n < n2 && (c = charSequence.charAt(n)) < '\u0080'; ++n) {
                    byteBuffer.put(n3 + n, (byte)c);
                }
                if (n == n2) {
                    byteBuffer.position(n3 + n);
                    return;
                }
                n3 += n;
                while (n < n2) {
                    c = charSequence.charAt(n);
                    if (c < '\u0080') {
                        byteBuffer.put(n3, (byte)c);
                    } else if (c < '\u0800') {
                        byteBuffer.put(n3++, (byte)(0xC0 | c >>> 6));
                        byteBuffer.put(n3, (byte)(0x80 | 0x3F & c));
                    } else if (c < '\ud800' || '\udfff' < c) {
                        byteBuffer.put(n3++, (byte)(0xE0 | c >>> 12));
                        byteBuffer.put(n3++, (byte)(0x80 | 0x3F & c >>> 6));
                        byteBuffer.put(n3, (byte)(0x80 | 0x3F & c));
                    } else {
                        char c2;
                        if (n + 1 == n2 || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n))) {
                            throw new UnpairedSurrogateException(n, n2);
                        }
                        int n4 = Character.toCodePoint(c, c2);
                        byteBuffer.put(n3++, (byte)(0xF0 | n4 >>> 18));
                        byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 12));
                        byteBuffer.put(n3++, (byte)(0x80 | 0x3F & n4 >>> 6));
                        byteBuffer.put(n3, (byte)(0x80 | 0x3F & n4));
                    }
                    ++n;
                    ++n3;
                }
                byteBuffer.position(n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                int n5 = byteBuffer.position() + Math.max(n, n3 - byteBuffer.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + charSequence.charAt(n) + " at index " + n5);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n, int n2) {
            super("Unpaired surrogate at index " + n + " of " + n2);
        }
    }
}

