/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Set;

@BugPattern(name="ObjectToString", summary="Calling toString on Objects that don't override toString() doesn't provide useful information", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class ObjectToString
extends AbstractToString {
    private static boolean finalNoOverrides(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        if (!type.isFinal()) {
            return false;
        }
        Types types = state.getTypes();
        Set overridesOfToString = ASTHelpers.findMatchingMethods((Name)state.getName("toString"), methodSymbol -> ObjectToString.isToString(methodSymbol, state), (Type)type, (Types)types);
        return overridesOfToString.size() == 1;
    }

    private static boolean isToString(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && state.getTypes().isSameType(methodSymbol.getReturnType(), state.getSymtab().stringType) && ((List)methodSymbol.getParameters()).isEmpty();
    }

    @Override
    protected TypePredicate typePredicate() {
        return ObjectToString::finalNoOverrides;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type) {
        String format = "%1$s is final and does not override Object.toString, converting it to a string will print its identity (e.g. `%1$s@ 4488aabb`) instead of useful information.";
        return Optional.of((Object)String.format(format, type.toString()));
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.absent();
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return Optional.absent();
    }
}

