/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import java.io.IOException;

public abstract class AbstractReplicatedMapClientRequest
extends PartitionClientRequest
implements RetryableRequest,
Portable {
    private String mapName;
    private int partitionId;

    protected AbstractReplicatedMapClientRequest() {
    }

    public AbstractReplicatedMapClientRequest(String mapName) {
        this.mapName = mapName;
    }

    public AbstractReplicatedMapClientRequest(String mapName, int partitionId) {
        this.mapName = mapName;
        this.partitionId = partitionId;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("mapName", this.mapName);
        writer.writeInt("pid", this.partitionId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.mapName = reader.readUTF("mapName");
        this.partitionId = reader.readInt("pid");
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public String getDistributedObjectName() {
        return this.mapName;
    }
}

