/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class BinaryLogProvider {
    private static final Logger logger = Logger.getLogger(BinaryLogProvider.class.getName());
    private static final BinaryLogProvider NULL_PROVIDER = new NullProvider();
    private static final BinaryLogProvider PROVIDER = BinaryLogProvider.load(BinaryLogProvider.class.getClassLoader());

    public static BinaryLogProvider provider() {
        return PROVIDER;
    }

    @VisibleForTesting
    static BinaryLogProvider load(ClassLoader classLoader) {
        try {
            return BinaryLogProvider.loadHelper(classLoader);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "caught exception loading BinaryLogProvider, will disable binary log", t);
            return NULL_PROVIDER;
        }
    }

    private static BinaryLogProvider loadHelper(ClassLoader classLoader) {
        if (BinaryLogProvider.isAndroid()) {
            return NULL_PROVIDER;
        }
        Iterator<BinaryLogProvider> iter = BinaryLogProvider.getCandidatesViaServiceLoader(classLoader).iterator();
        ArrayList<BinaryLogProvider> list = new ArrayList<BinaryLogProvider>();
        while (iter.hasNext()) {
            try {
                list.add(iter.next());
            }
            catch (ServiceConfigurationError e) {
                logger.log(Level.SEVERE, "caught exception creating an instance of BinaryLogProvider", e);
            }
        }
        if (list.isEmpty()) {
            return NULL_PROVIDER;
        }
        return Collections.max(list, new Comparator<BinaryLogProvider>(){

            @Override
            public int compare(BinaryLogProvider f1, BinaryLogProvider f2) {
                return f1.priority() - f2.priority();
            }
        });
    }

    private static ServiceLoader<BinaryLogProvider> getCandidatesViaServiceLoader(ClassLoader classLoader) {
        ServiceLoader<BinaryLogProvider> i = ServiceLoader.load(BinaryLogProvider.class, classLoader);
        if (!i.iterator().hasNext()) {
            i = ServiceLoader.load(BinaryLogProvider.class);
        }
        return i;
    }

    @Nullable
    public abstract ServerInterceptor getServerInterceptor(String var1);

    @Nullable
    public abstract ClientInterceptor getClientInterceptor(String var1);

    protected abstract int priority();

    protected static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, BinaryLogProvider.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @VisibleForTesting
    static final class NullProvider
    extends BinaryLogProvider {
        NullProvider() {
        }

        @Override
        @Nullable
        public ServerInterceptor getServerInterceptor(String fullMethodName) {
            return null;
        }

        @Override
        public ClientInterceptor getClientInterceptor(String fullMethodName) {
            return null;
        }

        @Override
        protected int priority() {
            return 0;
        }
    }
}

