/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_MemberWithIndex;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_OverloadKey;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(name="UngroupedOverloads", summary="Constructors and methods with the same name should appear sequentially with no other code in between", generateExamplesFromTestCases=false, category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s3.4.2.1-overloads-never-split")
public class UngroupedOverloads
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        LinkedHashMultimap methods = (LinkedHashMultimap)Streams.zip(Stream.iterate(0, i -> i + 1), classTree.getMembers().stream(), MemberWithIndex::create).filter(m -> m.tree() instanceof MethodTree).collect(Multimaps.toMultimap(m -> OverloadKey.create((MethodTree)m.tree()), x -> x, LinkedHashMultimap::create));
        methods.asMap().forEach((key, overloads) -> this.checkOverloads(state, classTree.getMembers(), key.name(), (Collection<MemberWithIndex>)overloads));
        return Description.NO_MATCH;
    }

    private void checkOverloads(VisitorState state, List<? extends Tree> members, Name name, Collection<MemberWithIndex> overloads) {
        if (overloads.size() <= 1) {
            return;
        }
        MemberWithIndex first = overloads.iterator().next();
        boolean grouped = Streams.zip(Stream.iterate(first.index(), i -> i + 1), overloads.stream().map(m -> m.index()), (a, b) -> Objects.equals(a, b)).allMatch(x -> x);
        if (grouped) {
            return;
        }
        if (overloads.stream().anyMatch(m -> this.isSuppressed(m.tree()))) {
            return;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        StringBuilder sb = new StringBuilder("\n");
        overloads.stream().filter(o -> o != first).forEach(o -> {
            int start = state.getEndPosition((Tree)members.get(o.index() - 1));
            int end = state.getEndPosition(o.tree());
            sb.append(state.getSourceCode(), start, end).append('\n');
            fixBuilder.replace(start, end, "");
        });
        fixBuilder.postfixWith(first.tree(), sb.toString());
        SuggestedFix fix = fixBuilder.build();
        String message = String.format("Overloads of '%s' are not grouped together.", name);
        overloads.stream().forEach(o -> state.reportMatch(this.buildDescription(o.tree()).addFix((Fix)fix).setMessage(message).build()));
    }

    @AutoValue
    static abstract class OverloadKey {
        OverloadKey() {
        }

        abstract Name name();

        public static OverloadKey create(MethodTree methodTree) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)methodTree);
            return new AutoValue_UngroupedOverloads_OverloadKey(sym.getSimpleName());
        }
    }

    @AutoValue
    static abstract class MemberWithIndex {
        MemberWithIndex() {
        }

        abstract int index();

        abstract Tree tree();

        static MemberWithIndex create(int index, Tree tree) {
            return new AutoValue_UngroupedOverloads_MemberWithIndex(index, tree);
        }
    }
}

